/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.util;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.impl.LogLevel;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ConsoleFormat {
    private ConsoleFormat() {
    }

    public static void setBatchMode(boolean batchMode) {
        Ansi.setEnabled((!batchMode ? 1 : 0) != 0);
    }

    public static boolean isBatchMode() {
        return Ansi.isEnabled();
    }

    @Nullable
    public static String formatActionStartMessage(Action action) {
        String operation = action.getOperationName();
        if (operation == null) {
            return null;
        }
        return Ansi.ansi().a("Starting ").fgGreen().a(operation).reset().toString();
    }

    public static String formatMessageWithErrorParameters(String message, Object ... parameters) {
        return ConsoleFormat.formatMessageWithParameters((String)message, (Object[])parameters, (Color)Color.ERROR);
    }

    public static String formatMessageWithSuccessParameters(String message, Object ... parameters) {
        return ConsoleFormat.formatMessageWithParameters((String)message, (Object[])parameters, (Color)Color.SUCCESS);
    }

    public static String formatMessageWithWarningParameters(String message, Object ... parameters) {
        return ConsoleFormat.formatMessageWithParameters((String)message, (Object[])parameters, (Color)Color.WARN);
    }

    public static String formatMessageWithInfoParameters(String message, Object ... parameters) {
        return ConsoleFormat.formatMessageWithParameters((String)message, (Object[])parameters, (Color)Color.INFO);
    }

    public static String formatMessageWithParameters(String message, Object[] parameters, Color level) {
        Object[] formatted = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            formatted[i] = Ansi.ansi().fgBright(level.color).a(parameters[i]).reset().toString();
        }
        return NinjaUtils.printFormatted((String)message, (Object[])formatted);
    }

    public static String formatSuccessMessage(String message) {
        return ConsoleFormat.formatMessage((String)message, (Color)Color.SUCCESS);
    }

    public static String formatMessage(String message, Color color) {
        return Ansi.ansi().fgBright(color.color).a(message).reset().toString();
    }

    public static String formatLogMessage(LogLevel level, String msg) {
        return Ansi.ansi().reset().a("[").fgBright(level.color()).a(level.label()).reset().a("] ").a(msg).toString();
    }

    public static String formatCommand(String message) {
        return Ansi.ansi().fgBright(Ansi.Color.WHITE).a(message).reset().toString();
    }

    public static String rewriteConsoleLine(String newLine) {
        return Ansi.ansi().eraseLine(Ansi.Erase.ALL).cursorUpLine().eraseLine(Ansi.Erase.ALL).a(newLine).toString();
    }

    public static String formatInputPrompt() {
        return Ansi.ansi().reset().a("[").fgBright(Ansi.Color.MAGENTA).a("INPUT").reset().a("] > ").toString();
    }
}

