/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.common.crypto.CryptoUtil;
import com.evolveum.midpoint.ninja.action.ImportOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.crypto.Protector;
import com.evolveum.midpoint.repo.api.RepoAddOptions;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;

public class ImportRepositoryConsumerWorker
extends BaseWorker<ImportOptions, ObjectType> {
    public ImportRepositoryConsumerWorker(NinjaContext context, ImportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation, List<ImportRepositoryConsumerWorker> consumers) {
        super(context, (Object)options, queue, operation, consumers);
    }

    public void run() {
        block12: {
            ApplicationContext ctx = this.context.getApplicationContext();
            Protector protector = (Protector)ctx.getBean(Protector.class);
            block7: while (true) {
                try {
                    while (!this.shouldConsumerStop()) {
                        ObjectType object = null;
                        try {
                            Class type;
                            RepositoryService repository;
                            object = (ObjectType)this.queue.poll(2L, TimeUnit.SECONDS);
                            if (object == null) continue;
                            PrismObject prismObject = object.asPrismObject();
                            RepoAddOptions opts = this.createRepoAddOptions((ImportOptions)this.options);
                            if (!opts.isAllowUnencryptedValues()) {
                                CryptoUtil.encryptValues((Protector)protector, (PrismObject)prismObject);
                            }
                            if (!(repository = this.context.getRepository()).supports(type = prismObject.getCompileTimeClass())) {
                                this.context.getLog().warn("Repository doesn't support import operation for objects of type '{}' ({}, {})", new Object[]{type.getSimpleName(), prismObject.getName(), prismObject.getOid()});
                                this.operation.incrementSkipped();
                                continue;
                            }
                            repository.addObject(prismObject, opts, new OperationResult("Import object"));
                            this.operation.incrementTotal();
                            continue block7;
                        }
                        catch (Exception ex) {
                            this.context.getLog().error("Couldn't add object {}, reason: {}", ex, new Object[]{object, ex.getMessage()});
                            this.operation.incrementError();
                        }
                    }
                    break block12;
                }
                catch (Exception ex) {
                    this.operation.finish();
                    throw ex;
                }
            }
            finally {
                this.markDone();
                if (this.isWorkersDone()) {
                    this.operation.finish();
                }
            }
        }
    }

    private RepoAddOptions createRepoAddOptions(ImportOptions options) {
        RepoAddOptions opts = new RepoAddOptions();
        opts.setOverwrite(options.isOverwrite());
        opts.setAllowUnencryptedValues(options.isAllowUnencryptedValues());
        return opts;
    }
}

