/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeInstallationOptions;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.InputParameterException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class UpgradeInstallationAction
extends Action<UpgradeInstallationOptions, Void> {
    private static final boolean IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");

    public String getOperationName() {
        return "upgrade installation";
    }

    public Void execute() throws Exception {
        File distributionDirectory = ((UpgradeInstallationOptions)this.options).getDistributionDirectory();
        if (distributionDirectory == null) {
            throw new InputParameterException("Undefined distribution directory option --distribution-directory");
        }
        boolean backupFiles = ((UpgradeInstallationOptions)this.options).isBackup();
        File midpointInstallation = NinjaUtils.computeInstallationDirectory((File)((UpgradeInstallationOptions)this.options).getInstallationDirectory(), (NinjaContext)this.context);
        if (midpointInstallation == null) {
            throw new NinjaException("Undefined midpoint installation directory");
        }
        this.log.info(ConsoleFormat.formatMessageWithInfoParameters((String)("Midpoint installation directory: " + midpointInstallation.getPath()), (Object[])new Object[0]), new Object[0]);
        File backupDirectory = null;
        if (backupFiles) {
            backupDirectory = new File(midpointInstallation, ".backup-" + System.currentTimeMillis());
            backupDirectory.mkdir();
            this.log.info("Backing up installation directory to: {}", new Object[]{backupDirectory.getAbsolutePath()});
        }
        for (File file : this.emptyIfNull(distributionDirectory.listFiles())) {
            this.backupAndCopyFiles(file, new File(midpointInstallation, file.getName()), backupFiles, backupDirectory);
        }
        this.log.info(ConsoleFormat.formatSuccessMessage((String)"Installation upgraded successfully"), new Object[0]);
        this.log.info("", new Object[0]);
        this.log.info("Next step should be to update initial objects. You can use 'ninja initial-objects --dry-run' to review changes.", new Object[0]);
        this.log.info("Please see documentation and initial-objects command options for more information.", new Object[0]);
        return null;
    }

    private void backupAndCopyFiles(File from, File to, boolean doBackup, File backupDirectory) throws IOException {
        if (from.isFile()) {
            Set<PosixFilePermission> permissions = null;
            if (to.exists()) {
                Set<PosixFilePermission> set = permissions = IS_POSIX ? Files.getPosixFilePermissions(to.toPath(), new LinkOption[0]) : null;
                if (doBackup) {
                    FileUtils.copyFile((File)to, (File)new File(backupDirectory, to.getName()), (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING});
                }
            }
            FileUtils.copyFile((File)from, (File)to, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING});
            if (permissions != null) {
                Files.setPosixFilePermissions(to.toPath(), permissions);
            }
            return;
        }
        Set<PosixFilePermission> permissions = null;
        if (to.exists()) {
            Set<PosixFilePermission> set = permissions = IS_POSIX ? Files.getPosixFilePermissions(to.toPath(), new LinkOption[0]) : null;
            if (doBackup) {
                File backedUp = new File(backupDirectory, to.getName());
                backedUp.mkdir();
                if (permissions != null) {
                    Files.setPosixFilePermissions(backedUp.toPath(), permissions);
                }
            }
        }
        to.mkdir();
        if (permissions != null) {
            Files.setPosixFilePermissions(to.toPath(), permissions);
        }
        for (File file : this.emptyIfNull(from.listFiles())) {
            this.backupAndCopyFiles(file, new File(to, file.getName()), doBackup, new File(backupDirectory, from.getName()));
        }
    }

    private File[] emptyIfNull(File[] files) {
        if (files == null) {
            return new File[0];
        }
        return files;
    }
}

