/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.init.AuditServiceProxy;
import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeConstants;
import com.evolveum.midpoint.ninja.action.upgrade.action.PreUpgradeCheckOptions;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.sqale.audit.SqaleAuditService;
import com.evolveum.midpoint.schema.LabeledString;
import com.evolveum.midpoint.schema.RepositoryDiag;
import com.evolveum.midpoint.schema.SearchResultList;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.NodeType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PreUpgradeCheckAction
extends Action<PreUpgradeCheckOptions, ActionResult<Boolean>> {
    public PreUpgradeCheckAction() {
    }

    public PreUpgradeCheckAction(boolean partial) {
        super(partial);
    }

    public String getOperationName() {
        return "pre-upgrade checks";
    }

    public ActionResult<Boolean> execute() throws Exception {
        RepositoryService repository = this.context.getRepository();
        if (!repository.isNative()) {
            this.log.error("Repository is not using native implementation for PostgreSQL (sqale)", new Object[0]);
            return new ActionResult((Object)false, 1);
        }
        if (!((PreUpgradeCheckOptions)this.options).isSkipNodesVersionCheck()) {
            if (!this.checkNodesVersion(repository)) {
                return new ActionResult((Object)false, 2);
            }
        } else {
            this.log.warn("Skipping nodes version check", new Object[0]);
        }
        if (!((PreUpgradeCheckOptions)this.options).isSkipDatabaseVersionCheck()) {
            if (!this.checkDatabaseSchemaVersion(repository)) {
                return new ActionResult((Object)false, 3);
            }
        } else {
            this.log.warn("Skipping database schema version check", new Object[0]);
        }
        this.log.info(ConsoleFormat.formatSuccessMessage((String)"Pre-upgrade checks finished successfully"), new Object[0]);
        return new ActionResult((Object)true);
    }

    private boolean checkDatabaseSchemaVersion(RepositoryService repository) {
        this.log.info("Checking database schema version", new Object[0]);
        RepositoryDiag repositoryInfo = repository.getRepositoryDiag();
        boolean result = this.validateChangeNumber(repositoryInfo.getAdditionalDetails(), "schemaChangeNumber", 50);
        if (!result) {
            return false;
        }
        AuditServiceProxy auditServiceProxy = (AuditServiceProxy)this.context.getApplicationContext().getBean(AuditServiceProxy.class);
        SqaleAuditService audit = (SqaleAuditService)auditServiceProxy.getImplementation(SqaleAuditService.class);
        if (audit == null) {
            this.log.info("Audit service is not configured, skipping audit schema version check", new Object[0]);
            return true;
        }
        RepositoryDiag auditInfo = audit.getRepositoryDiag();
        return this.validateChangeNumber(auditInfo.getAdditionalDetails(), "schemaAuditChangeNumber", 9);
    }

    private boolean validateChangeNumber(List<LabeledString> list, String label, int expected) {
        String number = this.getValue(list, label);
        boolean equals = Objects.equals(number, Integer.toString(expected));
        if (!equals) {
            this.log.error("Database schema change number ({}) doesn't match supported one ({}) for label {}.", new Object[]{number, expected, label});
        } else {
            this.log.info("Database schema change number matches supported one ({}) for label {}.", new Object[]{expected, label});
        }
        return equals;
    }

    private String getValue(List<LabeledString> list, String name) {
        if (list == null) {
            return null;
        }
        LabeledString labeled = list.stream().filter(ls -> name.equals(ls.getLabel())).findFirst().orElse(null);
        return labeled != null ? labeled.getData() : null;
    }

    private boolean checkNodesVersion(RepositoryService repository) throws SchemaException {
        this.log.info("Checking node versions in midPoint cluster", new Object[0]);
        OperationResult result = new OperationResult("Search nodes");
        SearchResultList nodes = repository.searchObjects(NodeType.class, null, null, result);
        HashSet versions = new HashSet();
        nodes.forEach(o -> {
            NodeType node = (NodeType)o.asObjectable();
            if (node.getBuild() == null) {
                return;
            }
            versions.add(node.getBuild().getVersion());
        });
        this.log.info("Found {} nodes in cluster", new Object[]{nodes.size()});
        this.log.info(ConsoleFormat.formatMessageWithInfoParameters((String)"Nodes version in cluster: {}", (Object[])new Object[]{StringUtils.join(versions, (String)", ")}), new Object[0]);
        if (versions.isEmpty()) {
            this.log.warn("There are zero nodes in cluster to validate current midPoint version.", new Object[0]);
            return true;
        }
        if (versions.size() > 1) {
            this.log.error("There are nodes with different versions of midPoint.", new Object[0]);
            this.log.error("Please remove incorrect nodes from cluster and related Node objects from repository.", new Object[0]);
            return false;
        }
        String version = (String)versions.iterator().next();
        if (!Objects.equals(version, UpgradeConstants.SUPPORTED_VERSION)) {
            this.log.error("There are midPoint nodes with versions " + Arrays.toString(versions.toArray()) + " that doesn't match supported version for upgrade (" + UpgradeConstants.SUPPORTED_VERSION + ")", new Object[0]);
            this.log.error("Make sure that all nodes in midPoint cluster are running same and supported version of midPoint, remove all obsolete Node objects from repository.", new Object[0]);
            return false;
        }
        return true;
    }
}

