/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade;

import com.evolveum.midpoint.ninja.action.upgrade.ProgressListener;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogLevel;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import java.text.DecimalFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ConsoleProgressListener
implements ProgressListener {
    private static final DecimalFormat PROGRESS_FORMAT = new DecimalFormat("###");
    private static final DecimalFormat SPEED_FORMAT = new DecimalFormat("####.##");
    private final Log log;
    private boolean firstUpdate = true;
    private long startTime;
    private long lastReportTime;

    public ConsoleProgressListener(Log log) {
        this.log = log;
    }

    public void update(long bytesRead, long contentLength, boolean done) {
        if (done) {
            this.log.info(ConsoleFormat.rewriteConsoleLine((String)ConsoleFormat.formatLogMessage((LogLevel)LogLevel.INFO, (String)ConsoleFormat.formatSuccessMessage((String)"Download complete"))), new Object[0]);
            return;
        }
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.startTime = System.currentTimeMillis();
            String size = contentLength == -1L ? "unknown" : FileUtils.byteCountToDisplaySize((long)contentLength);
            this.log.info(ConsoleFormat.formatMessageWithInfoParameters((String)"Download size: {}", (Object[])new Object[]{size}), new Object[0]);
            this.log.info(this.logProgress(bytesRead, contentLength), new Object[0]);
            this.lastReportTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastReportTime < 500L) {
            return;
        }
        this.log.info(ConsoleFormat.rewriteConsoleLine((String)this.logProgress(bytesRead, contentLength)), new Object[0]);
        this.lastReportTime = System.currentTimeMillis();
    }

    private String logProgress(long bytesRead, long contentLength) {
        double speed = (double)bytesRead / ((double)(System.currentTimeMillis() - this.startTime) / 1000.0);
        double speedMB = speed / 1024.0 / 1024.0;
        long estimatedDuration = (long)((double)(contentLength - bytesRead) / speed * 1000.0);
        double progress = (double)(100L * bytesRead) / (double)contentLength;
        return ConsoleFormat.formatLogMessage((LogLevel)LogLevel.INFO, (String)NinjaUtils.printFormatted((String)"Progress: {}\t{} MB/s\tETA: {}", (Object[])new Object[]{ConsoleFormat.formatMessage((String)(PROGRESS_FORMAT.format(progress) + "%"), (ConsoleFormat.Color)ConsoleFormat.Color.INFO), SPEED_FORMAT.format(speedMB), DurationFormatUtils.formatDurationWords((long)estimatedDuration, (boolean)true, (boolean)true)}));
    }
}

