/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining.generator.object;

import com.evolveum.midpoint.ninja.action.mining.generator.object.InitialObjectsDefinition;
import com.evolveum.midpoint.schema.util.FocusTypeUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InitialBusinessRole {
    public String getName();

    public String getOidValue();

    @Nullable
    public List<InitialObjectsDefinition.BasicAbstractRole> getAssociations();

    public String getArchetypeOid();

    default public RoleType generateRoleObject() {
        RoleType role = new RoleType();
        role.setName(PolyStringType.fromOrig((String)this.getName()));
        role.setOid(this.getOidValue());
        this.setUpArchetype(role);
        this.setUpInducements(role);
        return role;
    }

    private void setUpArchetype(@NotNull RoleType role) {
        ObjectReferenceType archetypeRef = new ObjectReferenceType().oid(this.getArchetypeOid()).type(ArchetypeType.COMPLEX_TYPE);
        AssignmentType targetAssignment = FocusTypeUtil.createTargetAssignment((ObjectReferenceType)archetypeRef);
        role.getAssignment().add(targetAssignment);
        role.getArchetypeRef().add(archetypeRef.clone());
    }

    private void setUpInducements(@NotNull RoleType role) {
        if (this.getAssociations() == null) {
            return;
        }
        this.getAssociations().forEach(association -> {
            List associations = association.getAssociations();
            if (associations != null) {
                associations.forEach(associationOid -> {
                    ObjectReferenceType associationRef = new ObjectReferenceType().oid(associationOid).type(RoleType.COMPLEX_TYPE);
                    role.getInducement().add(FocusTypeUtil.createTargetAssignment((ObjectReferenceType)associationRef));
                });
            } else {
                ObjectReferenceType associationRef = new ObjectReferenceType().oid(association.getOidValue()).type(RoleType.COMPLEX_TYPE);
                role.getInducement().add(FocusTypeUtil.createTargetAssignment((ObjectReferenceType)associationRef));
            }
        });
    }
}

