/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining.generator.object;

import com.evolveum.midpoint.schema.util.FocusTypeUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InitialAbstractRole {
    public String getName();

    public String getOidValue();

    @Nullable
    public List<String> getAssociations();

    public String getArchetypeOid();

    public int getAssociationsMultiplier();

    public boolean isArchetypeRoleEnable();

    default public List<RoleType> generateRoleObject() {
        List roleTypes = this.generateRoles();
        if (!roleTypes.isEmpty()) {
            return roleTypes;
        }
        RoleType role = new RoleType();
        role.setName(PolyStringType.fromOrig((String)this.getName()));
        role.setOid(this.getOidValue());
        if (this.isArchetypeRoleEnable()) {
            this.setUpArchetype(role);
        }
        return Collections.singletonList(role);
    }

    private void setUpArchetype(@NotNull RoleType role) {
        ObjectReferenceType archetypeRef = new ObjectReferenceType().oid(this.getArchetypeOid()).type(ArchetypeType.COMPLEX_TYPE);
        AssignmentType targetAssignment = FocusTypeUtil.createTargetAssignment((ObjectReferenceType)archetypeRef);
        role.getAssignment().add(targetAssignment);
        role.getArchetypeRef().add(archetypeRef.clone());
    }

    @NotNull
    private List<RoleType> generateRoles() {
        ArrayList<RoleType> roles = new ArrayList<RoleType>();
        if (this.getAssociations() == null) {
            return roles;
        }
        @Nullable List associations = this.getAssociations();
        for (int i = 0; i < associations.size(); ++i) {
            String association = (String)associations.get(i);
            RoleType roleClone = new RoleType();
            roleClone.setOid(association);
            roleClone.setName(PolyStringType.fromOrig((String)(this.getName() + "_" + (i + 1))));
            if (this.isArchetypeRoleEnable()) {
                this.setUpArchetype(roleClone);
            }
            roles.add(roleClone);
        }
        return roles;
    }
}

