/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining.generator.context;

import com.evolveum.midpoint.ninja.action.mining.generator.GeneratorOptions;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacGeneratorUtils;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacObjectCategoryProcessor;
import com.evolveum.midpoint.ninja.action.mining.generator.object.InitialObjectsDefinition;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.Referencable;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.GetOperationOptions;
import com.evolveum.midpoint.schema.ResultHandler;
import com.evolveum.midpoint.schema.SelectorOptions;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentHolderType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportAction {
    NinjaContext context;
    GeneratorOptions generatorOptions;
    OperationResult result;
    Log log;
    Set<String> names = null;
    boolean isArchetypeUserEnable;

    public ImportAction(@NotNull NinjaContext context, @NotNull GeneratorOptions generatorOptions, @NotNull OperationResult result) {
        this.context = context;
        this.generatorOptions = generatorOptions;
        this.isArchetypeUserEnable = generatorOptions.isArchetypeUserEnable();
        this.result = result;
        this.log = context.getLog();
    }

    public void executeImport() {
        RepositoryService repositoryService = this.context.getRepository();
        if (this.generatorOptions.isImport()) {
            this.initialObjectsImport(repositoryService);
            this.importUsers(this.generatorOptions.getUsersCount(), this.generatorOptions.getCsvPath());
        }
        if (this.generatorOptions.isTransform()) {
            this.log.info("Make sure that RoleType objects is recomputed", new Object[0]);
            ImportAction.remakeUsersBusinessRoles((NinjaContext)this.context, (OperationResult)this.result, (GeneratorOptions)this.generatorOptions, null, null);
        }
    }

    private void initialObjectsImport(@NotNull RepositoryService repositoryService) {
        this.log.info("Importing initial role objects", new Object[0]);
        InitialObjectsDefinition initialObjectsDefinition = new InitialObjectsDefinition(this.generatorOptions);
        this.importOrganizations(initialObjectsDefinition, repositoryService, this.result, this.log);
        if (this.isArchetypeUserEnable) {
            this.importArchetypes(initialObjectsDefinition, repositoryService, this.result, this.log);
        }
        if (!this.generatorOptions.isPlanktonDisable() || (double)this.generatorOptions.getOutlierZombieProbability() != 0.0) {
            this.importPlanktonRoles(initialObjectsDefinition, repositoryService, this.result, this.log);
        }
        this.importMultipliedBasicRoles(initialObjectsDefinition, repositoryService, this.result, this.log);
        this.importBusinessRoles(initialObjectsDefinition, repositoryService, this.result, this.log);
        this.importNoiseRoles(repositoryService, this.result, this.log);
        this.log.info("Initial role objects imported", new Object[0]);
    }

    private void importMultipliedBasicRoles(@NotNull InitialObjectsDefinition initialObjectsDefinition, @NotNull RepositoryService repositoryService, OperationResult result, @NotNull Log log) {
        InitialObjectsDefinition.BasicAbstractRole[] basicMultiplierRoles = initialObjectsDefinition.getBasicRolesObjects();
        log.info("Importing basic roles: 0/{}", new Object[]{basicMultiplierRoles.length});
        for (int i = 0; i < basicMultiplierRoles.length; ++i) {
            log.info("Importing basic roles: {}/{}", new Object[]{i + 1, basicMultiplierRoles.length});
            InitialObjectsDefinition.BasicAbstractRole rolesObject = basicMultiplierRoles[i];
            List role = rolesObject.generateRoleObject();
            for (RoleType roleType : role) {
                this.importRole(roleType, repositoryService, result, log);
            }
        }
    }

    private void importBusinessRoles(@NotNull InitialObjectsDefinition initialObjectsDefinition, @NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        List rolesObjects = initialObjectsDefinition.getBusinessRolesObjects();
        log.info("Importing business roles: 0/{}", new Object[]{rolesObjects.size()});
        for (int i = 0; i < rolesObjects.size(); ++i) {
            log.info("Importing business roles: {}/{}", new Object[]{i + 1, rolesObjects.size()});
            RoleType role = (RoleType)rolesObjects.get(i);
            try {
                repositoryService.addObject(role.asPrismObject(), null, result);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                log.warn("Role {} already exists", new Object[]{role.getName()});
                continue;
            }
            catch (SchemaException e) {
                log.error("Error adding role {}", new Object[]{role.getName(), e});
                throw new RuntimeException(e);
            }
        }
    }

    private void importPlanktonRoles(@NotNull InitialObjectsDefinition initialObjectsDefinition, @NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        List rolesObjects = initialObjectsDefinition.getPlanktonRolesObjects();
        log.info("Importing plankton roles: 0/{}", new Object[]{rolesObjects.size()});
        for (int i = 0; i < rolesObjects.size(); ++i) {
            log.info("Importing plankton roles: {}/{}", new Object[]{i + 1, rolesObjects.size()});
            RoleType role = (RoleType)rolesObjects.get(i);
            try {
                repositoryService.addObject(role.asPrismObject(), null, result);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                log.warn("Role {} already exists", new Object[]{role.getName()});
                continue;
            }
            catch (SchemaException e) {
                log.error("Error adding role {}", new Object[]{role.getName(), e});
                throw new RuntimeException(e);
            }
        }
    }

    private void importNoiseRoles(@NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        List rolesObjects = InitialObjectsDefinition.getNoiseRolesObjects();
        log.info("Importing noise roles: 0/{}", new Object[]{rolesObjects.size()});
        for (int i = 0; i < rolesObjects.size(); ++i) {
            log.info("Importing noise roles: {}/{}", new Object[]{i + 1, rolesObjects.size()});
            RoleType role = (RoleType)rolesObjects.get(i);
            try {
                repositoryService.addObject(role.asPrismObject(), null, result);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                log.warn("Role {} already exists", new Object[]{role.getName()});
                continue;
            }
            catch (SchemaException e) {
                log.error("Error adding role {}", new Object[]{role.getName(), e});
                throw new RuntimeException(e);
            }
        }
    }

    private void importRole(@NotNull RoleType role, @NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        try {
            repositoryService.addObject(role.asPrismObject(), null, result);
        }
        catch (ObjectAlreadyExistsException e) {
            log.warn("Role {} already exists", new Object[]{role.getName()});
        }
        catch (SchemaException e) {
            log.error("Error adding role {}", new Object[]{role.getName(), e});
            throw new RuntimeException(e);
        }
    }

    private void importOrganizations(@NotNull InitialObjectsDefinition initialObjectsDefinition, @NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        List orgObjects = initialObjectsDefinition.getOrgObjects();
        log.info("Importing organizations: 0/{}", new Object[]{orgObjects.size()});
        for (int i = 0; i < orgObjects.size(); ++i) {
            log.info("Importing organizations: {}/{}", new Object[]{i + 1, orgObjects.size()});
            OrgType org = (OrgType)orgObjects.get(i);
            try {
                repositoryService.addObject(org.asPrismObject(), null, result);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                log.warn("Org {} already exists", new Object[]{org.getName()});
                continue;
            }
            catch (SchemaException e) {
                log.error("Error adding org {}", new Object[]{org.getName(), e});
                throw new RuntimeException(e);
            }
        }
    }

    private void importArchetypes(@NotNull InitialObjectsDefinition initialObjectsDefinition, @NotNull RepositoryService repositoryService, @NotNull OperationResult result, @NotNull Log log) {
        List archetypeObjects = initialObjectsDefinition.getArchetypeObjects();
        log.info("Importing archetypes: 0/{}", new Object[]{archetypeObjects.size()});
        for (int i = 0; i < archetypeObjects.size(); ++i) {
            log.info("Importing archetypes: {}/{}", new Object[]{i + 1, archetypeObjects.size()});
            ArchetypeType archetype = (ArchetypeType)archetypeObjects.get(i);
            try {
                repositoryService.addObject(archetype.asPrismObject(), null, result);
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                log.warn("Archetype {} already exists", new Object[]{archetype.getName()});
                continue;
            }
            catch (SchemaException e) {
                log.error("Error adding org {}", new Object[]{archetype.getName(), e});
                throw new RuntimeException(e);
            }
        }
    }

    public static void importUserAndResolveAuxRoles(@NotNull UserType user, @NotNull RepositoryService repositoryService, @NotNull GeneratorOptions generatorOptions, @NotNull OperationResult result, @NotNull Log log) {
        if (generatorOptions.isAuxInclude()) {
            RbacGeneratorUtils.resolveAuxRoles((UserType)user);
        }
        try {
            repositoryService.addObject(user.asPrismObject(), null, result);
        }
        catch (ObjectAlreadyExistsException e) {
            log.warn("User {} already exists", new Object[]{user.getName()});
        }
        catch (SchemaException e) {
            log.error("Error adding user {}", new Object[]{user.getName(), e});
            throw new RuntimeException(e);
        }
    }

    private void importUsers(int usersCount, @Nullable String csvPath) {
        this.log.info("Importing users", new Object[0]);
        if (csvPath != null) {
            this.names = new HashSet();
            try {
                this.names = RbacGeneratorUtils.loadNamesFromCSV((String)csvPath);
            }
            catch (IOException e) {
                this.log.error("Error loading names from CSV file", (Exception)e, new Object[0]);
                throw new RuntimeException(e);
            }
        }
        this.generateAndImportUsers(usersCount);
        this.log.info("Users imported", new Object[0]);
    }

    public void generateAndImportUsers(int userCount) {
        String division = this.generatorOptions.getDivision();
        String[] parts = division.split(":");
        int sum = 0;
        int[] partsInt = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int value = Integer.parseInt(part);
            sum += value;
            partsInt[i] = value;
        }
        if (sum != 100) {
            this.log.error("Division is not valid. Sum of parts is not 100 but " + sum, new Object[0]);
            throw new IllegalArgumentException("Division is not valid. Sum of parts is not 100 but " + sum);
        }
        if (parts.length != 7) {
            this.log.error("Division is not valid. It should contain 7 parts but it contains " + parts.length, new Object[0]);
            throw new IllegalArgumentException("Division is not valid. It should contain 7 parts but it contains " + parts.length);
        }
        int regularUsersCount = (int)((double)userCount * ((double)partsInt[0] / 100.0));
        int semiRegularUsersCount = (int)((double)userCount * ((double)partsInt[1] / 100.0));
        int irregularUsersCount = (int)((double)userCount * ((double)partsInt[2] / 100.0));
        int managersCount = (int)((double)userCount * ((double)partsInt[3] / 100.0));
        int salesCount = (int)((double)userCount * ((double)partsInt[4] / 100.0));
        int securityOfficersCount = (int)((double)userCount * ((double)partsInt[5] / 100.0));
        int contractorsCount = (int)((double)userCount * ((double)partsInt[6] / 100.0));
        RepositoryService repository = this.context.getRepository();
        this.resolveUsers(repository, regularUsersCount, RbacObjectCategoryProcessor.Category.REGULR, this.names);
        this.resolveUsers(repository, semiRegularUsersCount, RbacObjectCategoryProcessor.Category.SEMI_REGULAR, this.names);
        this.resolveUsers(repository, irregularUsersCount, RbacObjectCategoryProcessor.Category.IRREGULAR, this.names);
        this.resolveUsers(repository, managersCount, RbacObjectCategoryProcessor.Category.MANAGERS, this.names);
        this.resolveUsers(repository, salesCount, RbacObjectCategoryProcessor.Category.SALES, this.names);
        this.resolveUsers(repository, securityOfficersCount, RbacObjectCategoryProcessor.Category.SECURITY_OFFICERS, this.names);
        this.resolveUsers(repository, contractorsCount, RbacObjectCategoryProcessor.Category.CONTRACTORS, this.names);
    }

    private void resolveUsers(@NotNull RepositoryService repository, int usersCount, RbacObjectCategoryProcessor.Category category, Set<String> names) {
        RbacObjectCategoryProcessor.generateRbacData((RepositoryService)repository, (RbacObjectCategoryProcessor.Category)category, (Log)this.log, (GeneratorOptions)this.generatorOptions, (int)usersCount, names, (OperationResult)this.result);
    }

    public static void remakeUsersBusinessRoles(@NotNull NinjaContext context, @NotNull OperationResult result, @NotNull GeneratorOptions generatorOptions, @Nullable ObjectQuery query, @Nullable Collection<SelectorOptions<GetOperationOptions>> options) {
        RepositoryService repository = context.getRepository();
        Log log = context.getLog();
        log.info("Replace business role for their inducements on users started", new Object[0]);
        ResultHandler handler = (object, parentResult) -> {
            ImportAction.executeChangesOnUser((OperationResult)result, (PrismObject)object, (GeneratorOptions)generatorOptions, (RepositoryService)repository, (Log)log);
            return true;
        };
        try {
            repository.searchObjectsIterative(UserType.class, query, handler, options, false, result);
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        log.info("Replace business role for their inducements on users finished", new Object[0]);
    }

    private static void executeChangesOnUser(@NotNull OperationResult result, @NotNull PrismObject<UserType> object, @NotNull GeneratorOptions generatorOptions, @NotNull RepositoryService repository, @NotNull Log log) {
        List rolesOidAssignment;
        String userOid = object.getOid();
        PolyString name = object.getName();
        if (name == null) {
            return;
        }
        String stringName = name.toString();
        if (stringName.equals("administrator")) {
            return;
        }
        UserType userObject = (UserType)object.asObjectable();
        try {
            rolesOidAssignment = RbacGeneratorUtils.getBusinessRolesOidAssignment((AssignmentHolderType)userObject, (RepositoryService)repository, (OperationResult)result);
        }
        catch (ObjectNotFoundException | SchemaException e) {
            log.error("Error while getting roles oid assignment for user: {}", new Object[]{userOid, e});
            throw new RuntimeException(e);
        }
        for (PrismObject roleTypePrismObject : rolesOidAssignment) {
            RoleType role = (RoleType)roleTypePrismObject.asObjectable();
            List inducement = role.getInducement();
            ArrayList<ItemDelta> modifications = new ArrayList<ItemDelta>();
            try {
                RoleType noiseRole = RbacGeneratorUtils.getAdditionNoiseRole((int)generatorOptions.getAdditionNoise());
                if (noiseRole != null) {
                    modifications.add(PrismContext.get().deltaFor(UserType.class).item((ItemPath)UserType.F_ASSIGNMENT).add(new Object[]{RbacGeneratorUtils.createRoleAssignment((String)noiseRole.getOid())}).asItemDelta());
                }
                for (AssignmentType assignmentType : inducement) {
                    boolean allowed = RbacGeneratorUtils.isForgetRole((int)generatorOptions.getForgetNoise());
                    if (allowed) continue;
                    modifications.add(PrismContext.get().deltaFor(UserType.class).item((ItemPath)UserType.F_ASSIGNMENT).add(new Object[]{RbacGeneratorUtils.createRoleAssignment((String)assignmentType.getTargetRef().getOid())}).asItemDelta());
                }
                modifications.add(PrismContext.get().deltaFor(UserType.class).item((ItemPath)UserType.F_ASSIGNMENT).delete(new Object[]{RbacGeneratorUtils.createRoleAssignment((String)role.getOid())}).asItemDelta());
                repository.modifyObject(UserType.class, userOid, modifications, result);
            }
            catch (ObjectAlreadyExistsException | ObjectNotFoundException | SchemaException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("User {} prepared", new Object[]{name});
    }

    public static PolyStringType getNameFromSet(PolyStringType initialName, Set<String> names) {
        if (names == null || names.isEmpty()) {
            return initialName;
        }
        String name = names.iterator().next();
        names.remove(name);
        return PolyStringType.fromOrig((String)name);
    }

    public static <V> void addExtensionValue(Containerable extContainer, String itemName, V ... values) {
        PrismContainerValue pcv = extContainer.asPrismContainerValue();
        ItemDefinition itemDefinition = pcv.getDefinition().findItemDefinition((ItemPath)new ItemName(itemName));
        try {
            if (itemDefinition instanceof PrismReferenceDefinition) {
                PrismReference ref = (PrismReference)itemDefinition.instantiate();
                for (V value : values) {
                    ref.add((PrismValue)(value instanceof PrismReferenceValue ? (PrismReferenceValue)value : ((Referencable)value).asReferenceValue()));
                }
                pcv.add((Item)ref);
            } else {
                PrismProperty property = (PrismProperty)itemDefinition.instantiate();
                property.setRealValues((Object[])values);
                pcv.add((Item)property);
            }
        }
        catch (SchemaException e) {
            throw new RuntimeException("Cloud not add extension value", e);
        }
    }
}

