/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.schema.validator.ObjectValidator;
import com.evolveum.midpoint.schema.validator.ValidationResult;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordReferenceValueType;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectDeltaOperationType;
import com.evolveum.prism.xml.ns._public.types_3.ObjectDeltaType;

public class AuditRecordValidator {
    private static final ItemName F_OID = new ItemName("http://prism.evolveum.com/xml/ns/public/types-3", "oid");
    private static final ItemPath DELTA_RESOURCE_OID = ItemPath.create((Object[])new Object[]{AuditEventRecordType.F_DELTA, ObjectDeltaOperationType.F_RESOURCE_OID});
    private static final ItemPath DELTA_OBJECT_DELTA_OID = ItemPath.create((Object[])new Object[]{AuditEventRecordType.F_DELTA, ObjectDeltaOperationType.F_OBJECT_DELTA, F_OID});
    private static final ItemPath REFERENCE_VALUE_OID = ItemPath.create((Object[])new Object[]{AuditEventRecordType.F_REFERENCE, AuditEventRecordReferenceType.F_VALUE, AuditEventRecordReferenceValueType.F_OID});
    private final ObjectValidator validator;

    public AuditRecordValidator(ObjectValidator validator) {
        this.validator = validator;
    }

    public ValidationResult validate(AuditEventRecordType record) {
        PrismContainerValue recordPcv = record.asPrismContainerValue();
        ValidationResult result = this.validator.validate(recordPcv);
        this.checkAdditionalOid(result, recordPcv, AuditEventRecordType.F_RESOURCE_OID);
        this.checkAdditionalOid(result, recordPcv, AuditEventRecordType.F_TASK_OID);
        for (ObjectDeltaOperationType delta : record.getDelta()) {
            this.checkDelta(result, delta);
        }
        for (AuditEventRecordReferenceType reference : record.getReference()) {
            this.checkAuditReference(result, reference);
        }
        return result;
    }

    private void checkDelta(ValidationResult result, ObjectDeltaOperationType delta) {
        this.validator.checkOid(result, DELTA_RESOURCE_OID, delta.getResourceOid());
        this.checkObjectDelta(result, delta.getObjectDelta());
    }

    private void checkObjectDelta(ValidationResult result, ObjectDeltaType delta) {
        if (delta == null) {
            return;
        }
        this.validator.checkOid(result, DELTA_OBJECT_DELTA_OID, delta.getOid());
    }

    private void checkAuditReference(ValidationResult result, AuditEventRecordReferenceType reference) {
        if (reference == null) {
            return;
        }
        for (AuditEventRecordReferenceValueType ref : reference.getValue()) {
            this.validator.checkOid(result, REFERENCE_VALUE_OID, ref.getOid());
        }
    }

    private void checkAdditionalOid(ValidationResult result, PrismContainerValue auditPcv, ItemName name) {
        Item maybe = auditPcv.findItem((ItemPath)name);
        if (maybe instanceof PrismProperty) {
            PrismProperty prop = (PrismProperty)maybe;
            for (PrismPropertyValue val : prop.getValues()) {
                this.validator.checkOid(result, (PrismValue)val, (String)val.getRealValue());
            }
        }
    }
}

