/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.AbstractRepositorySearchAction;
import com.evolveum.midpoint.ninja.action.VerifyOptions;
import com.evolveum.midpoint.ninja.action.VerifyResult;
import com.evolveum.midpoint.ninja.action.verify.VerificationReporter;
import com.evolveum.midpoint.ninja.action.worker.VerifyConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.ParsingContext;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismParser;
import com.evolveum.midpoint.schema.validator.UpgradeValidationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class VerifyAction
extends AbstractRepositorySearchAction<VerifyOptions, VerifyResult> {
    public VerifyAction() {
    }

    public VerifyAction(boolean partial) {
        super(partial);
    }

    public String getOperationName() {
        return "verify";
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        VerifyOptions options = (VerifyOptions)NinjaUtils.getOptions(allOptions, VerifyOptions.class);
        if (options != null && !options.getFiles().isEmpty()) {
            return NinjaApplicationContextLevel.NO_REPOSITORY;
        }
        return super.getApplicationContextLevel(allOptions);
    }

    protected Callable<VerifyResult> createConsumer(BlockingQueue<ObjectType> queue, OperationStatus operation) {
        return () -> {
            VerifyConsumerWorker worker = new VerifyConsumerWorker(this.context, (VerifyOptions)this.options, queue, operation);
            worker.run();
            return worker.getResult();
        };
    }

    private void guessReportStyle() {
        if (((VerifyOptions)this.options).getOutput() == null) {
            ((VerifyOptions)this.options).setReportStyle(VerifyOptions.ReportStyle.PLAIN);
            return;
        }
        File output = ((VerifyOptions)this.options).getOutput();
        String extension = FilenameUtils.getExtension((String)output.getName());
        VerifyOptions.ReportStyle style = "csv".equalsIgnoreCase(extension) ? VerifyOptions.ReportStyle.CSV : VerifyOptions.ReportStyle.PLAIN;
        ((VerifyOptions)this.options).setReportStyle(style);
    }

    public VerifyResult execute() throws Exception {
        if (((VerifyOptions)this.options).getReportStyle() == null) {
            this.guessReportStyle();
        }
        if (((VerifyOptions)this.options).getOutput() != null) {
            this.log.info("Verification report will be saved to '{}' ({})", new Object[]{((VerifyOptions)this.options).getOutput().getPath(), ((VerifyOptions)this.options).getReportStyle().name().toLowerCase()});
        } else if (this.context.isUserMode() && !this.partial) {
            this.log.warn("Consider using '-o verify-output.csv --report-style " + VerifyOptions.ReportStyle.CSV.name().toLowerCase() + "' option for CSV output with upgradeability status of deprecated items.", new Object[0]);
            this.log.warn("It is recommended to review this report and actions for proper upgrade procedure.", new Object[0]);
        }
        VerifyResult result = !((VerifyOptions)this.options).getFiles().isEmpty() ? this.verifyFiles() : (VerifyResult)super.execute();
        this.log.info("", new Object[0]);
        this.log.info("Verification finished. {}, {}, {} and {} unknown issues found.", new Object[]{ConsoleFormat.formatMessageWithErrorParameters((String)"{} critical", (Object[])new Object[]{result.getCriticalCount()}), ConsoleFormat.formatMessageWithWarningParameters((String)"{} necessary", (Object[])new Object[]{result.getNecessaryCount()}), ConsoleFormat.formatMessageWithInfoParameters((String)"{} optional", (Object[])new Object[]{result.getOptionalCount()}), result.getUnknownCount()});
        if (((VerifyOptions)this.options).getOutput() != null) {
            this.log.info("", new Object[0]);
            this.log.info("Verification report saved to '{}'", new Object[]{((VerifyOptions)this.options).getOutput().getPath()});
            if (Objects.equals(VerifyOptions.ReportStyle.CSV, ((VerifyOptions)this.options).getReportStyle())) {
                this.log.info("XML dump with delta for each item saved to '{}'", new Object[]{((VerifyOptions)this.options).getOutput().getPath() + ".delta.xml"});
            }
            if (this.context.isUserMode() && !this.partial) {
                if (result.getCriticalCount() > 0L) {
                    this.log.info("", new Object[0]);
                    this.log.info("Critical issues should be fixed before upgrade as they could cause major problems after upgrade (e.g. prevent midpoint start).", new Object[0]);
                }
                this.log.info("", new Object[0]);
                this.log.info("Please see documentation for use of verification report in upgrade process and modify it accordingly.", new Object[0]);
                this.log.info("After you've reviewed verification report and marked changes to skip you can continue upgrade process with running 'ninja.sh upgrade-objects --verification-file \"{}\"'", new Object[]{((VerifyOptions)this.options).getOutput().getPath()});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyResult verifyFiles() throws IOException {
        VerificationReporter reporter = new VerificationReporter((VerifyOptions)this.options, this.context.getPrismContext(), this.context.getCharset(), this.log);
        reporter.setCreateDeltaFile(true);
        try (Writer writer = NinjaUtils.createWriter((File)((VerifyOptions)this.options).getOutput(), (Charset)this.context.getCharset(), (boolean)((VerifyOptions)this.options).isZip(), (boolean)((VerifyOptions)this.options).isOverwrite(), (PrintStream)this.context.out);){
            String epilog;
            reporter.init();
            String prolog = reporter.getProlog();
            if (prolog != null) {
                writer.write(prolog);
            }
            for (File file : ((VerifyOptions)this.options).getFiles()) {
                File child;
                if (!file.isDirectory()) {
                    if (this.verifyFile(file, reporter, writer)) continue;
                    break;
                }
                Collection children = FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true);
                Iterator iterator = children.iterator();
                while (iterator.hasNext() && ((child = (File)iterator.next()).isDirectory() || this.verifyFile(child, reporter, writer))) {
                }
            }
            if ((epilog = reporter.getEpilog()) != null) {
                writer.write(epilog);
            }
        }
        finally {
            reporter.destroy();
        }
        return reporter.getResult();
    }

    private boolean verifyFile(File file, VerificationReporter reporter, Writer writer) {
        PrismContext prismContext = this.context.getPrismContext();
        ParsingContext parsingContext = prismContext.createParsingContextForCompatibilityMode();
        PrismParser parser = prismContext.parserFor(file).language("xml").context(parsingContext);
        boolean shouldContinue = true;
        try {
            List objects = parser.parseObjects();
            for (PrismObject object : objects) {
                UpgradeValidationResult result = reporter.verify(writer, object);
                if (!((VerifyOptions)this.options).isStopOnCriticalError() || !result.hasCritical()) continue;
                shouldContinue = false;
            }
        }
        catch (Exception ex) {
            this.log.error("Couldn't verify file '{}'", ex, new Object[]{file.getPath()});
        }
        return shouldContinue;
    }
}

