/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.util;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class EnumConverterValidator<T extends Enum>
implements IStringConverter<T>,
IParameterValidator {
    private Class<T> enumClass;

    public EnumConverterValidator(@NotNull Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public void validate(String name, String value) throws ParameterException {
        Enum converted = this.convert(value);
        if (converted == null) {
            throw new ParameterException("Unknown value '" + value + "', supported values: " + Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(c -> c.name().toLowerCase()).toArray()));
        }
    }

    public T convert(String value) {
        if (value == null) {
            return null;
        }
        for (Enum t : (Enum[])this.enumClass.getEnumConstants()) {
            if (!t.name().equalsIgnoreCase(value)) continue;
            return (T)t;
        }
        return null;
    }
}

