/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.impl;

import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogLevel;
import com.evolveum.midpoint.ninja.impl.LogVerbosity;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;

public class Log {
    private final LogVerbosity level;
    private final PrintStream stream;

    public Log(@NotNull LogVerbosity level, @NotNull PrintStream stream) {
        this.level = level;
        this.stream = stream;
    }

    public void error(String message, Object ... args) {
        this.error(message, null, args);
    }

    public void error(String message, Exception ex, Object ... args) {
        if (ex != null) {
            message = (String)message + ". Reason: " + ex.getMessage();
        }
        this.log(LogLevel.ERROR, (String)message, args);
        if (ex != null && this.level == LogVerbosity.VERBOSE) {
            this.log(LogLevel.DEBUG, "Exception details:\n{}", new Object[]{ex});
        }
    }

    public void warn(String message, Object ... args) {
        this.log(LogLevel.WARNING, message, args);
    }

    public void debug(String message, Object ... args) {
        this.log(LogLevel.DEBUG, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(LogLevel.INFO, message, args);
    }

    public void log(LogLevel level, String message, Object ... args) {
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$impl$LogVerbosity[this.level.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (level != LogLevel.DEBUG) break;
                return;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof Exception) || level != LogLevel.DEBUG) continue;
            args[i] = NinjaUtils.printStackToString((Exception)((Exception)arg));
        }
        String formatted = NinjaUtils.printFormatted((String)message, (Object[])args);
        this.stream.println(ConsoleFormat.formatLogMessage((LogLevel)level, (String)formatted));
    }

    public void logRaw(String message) {
        this.stream.print(message);
    }
}

