/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.GetOperationOptionsBuilder;
import com.evolveum.midpoint.schema.ResultHandler;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class SearchProducerWorker
extends BaseWorker<ExportOptions, ObjectType> {
    private final ObjectTypes type;
    private final ObjectQuery query;

    public SearchProducerWorker(NinjaContext context, ExportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation, List<SearchProducerWorker> producers, ObjectTypes type, ObjectQuery query) {
        super(context, (Object)options, queue, operation, producers);
        this.type = type;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log log = this.context.getLog();
        try {
            GetOperationOptionsBuilder optionsBuilder = this.context.getSchemaService().getOperationOptionsBuilder();
            if (((ExportOptions)this.options).isRaw()) {
                optionsBuilder = optionsBuilder.raw();
            }
            optionsBuilder = NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, (Class)this.type.getClassDefinition());
            ResultHandler handler = (object, parentResult) -> {
                try {
                    if (this.operation.isFinished()) {
                        return false;
                    }
                    this.queue.put((ObjectType)object.asObjectable());
                }
                catch (InterruptedException ex) {
                    log.error("Couldn't queue object {}, reason: {}", (Exception)ex, new Object[]{object, ex.getMessage()});
                }
                return true;
            };
            RepositoryService repository = this.context.getRepository();
            if (repository.supports(this.type.getClassDefinition())) {
                repository.searchObjectsIterative(this.type.getClassDefinition(), this.query, handler, optionsBuilder.build(), true, this.operation.getResult());
            } else {
                log.debug("Type {} is not supported on current repository", new Object[]{this.type});
            }
        }
        catch (SchemaException ex) {
            log.error("Unexpected exception, reason: {}", (Exception)((Object)ex), new Object[]{ex.getMessage()});
        }
        catch (NinjaException ex) {
            log.error(ex.getMessage(), (Exception)((Object)ex), new Object[0]);
        }
        finally {
            this.markDone();
            if (this.isWorkersDone() && !this.operation.isFinished()) {
                this.operation.producerFinish();
            }
        }
    }
}

