/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public abstract class BaseWorker<O, T>
implements Runnable {
    public static final int CONSUMER_POLL_TIMEOUT = 2;
    private final List<? extends BaseWorker<?, ?>> workers;
    protected BlockingQueue<T> queue;
    protected NinjaContext context;
    protected O options;
    protected OperationStatus operation;
    private boolean done;

    public BaseWorker(NinjaContext context, O options, BlockingQueue<T> queue, OperationStatus operation) {
        this(context, options, queue, operation, null);
    }

    public BaseWorker(NinjaContext context, O options, BlockingQueue<T> queue, OperationStatus operation, List<? extends BaseWorker<?, ?>> workers) {
        this.queue = queue;
        this.context = context;
        this.options = options;
        this.operation = operation;
        this.workers = workers;
    }

    protected boolean shouldConsumerStop() {
        if (this.operation.isFinished()) {
            return true;
        }
        if (this.operation.isStarted()) {
            return false;
        }
        return !this.operation.isProducerFinished() || this.queue.isEmpty();
    }

    public boolean isDone() {
        return this.done;
    }

    public void markDone() {
        this.done = true;
    }

    protected boolean isWorkersDone() {
        if (this.workers == null) {
            return true;
        }
        for (BaseWorker worker : this.workers) {
            if (worker.isDone()) continue;
            return false;
        }
        return true;
    }
}

