/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public abstract class AbstractWriterConsumerWorker<O extends BasicExportOptions, T>
extends BaseWorker<O, T> {
    public AbstractWriterConsumerWorker(NinjaContext context, O options, BlockingQueue<T> queue, OperationStatus operation) {
        super(context, options, queue, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log log = this.context.getLog();
        Writer writer = null;
        try {
            this.init();
            writer = this.createWriter();
            while (!this.shouldConsumerStop()) {
                Object object = null;
                try {
                    object = this.queue.poll(2L, TimeUnit.SECONDS);
                    if (object == null) continue;
                    this.write(writer, object);
                    writer.flush();
                    this.operation.incrementTotal();
                }
                catch (Exception ex) {
                    log.error("Couldn't store object {}, reason: {}", ex, new Object[]{object, ex.getMessage()});
                    this.operation.incrementError();
                }
            }
            this.finalizeWriter(writer);
        }
        catch (IOException ex) {
            log.error("Unexpected exception, reason: {}", (Exception)ex, new Object[]{ex.getMessage()});
            this.operation.finish();
        }
        catch (NinjaException ex) {
            log.error(ex.getMessage(), (Exception)((Object)ex), new Object[0]);
            this.operation.finish();
        }
        finally {
            if (((BasicExportOptions)this.options).getOutput() != null) {
                IOUtils.closeQuietly((Writer)writer);
            }
            this.markDone();
            if (this.isWorkersDone()) {
                this.operation.finish();
            }
            this.destroy();
        }
    }

    protected void init() {
    }

    protected void destroy() {
    }

    protected abstract String getProlog();

    protected abstract void write(Writer var1, T var2) throws SchemaException, IOException;

    protected abstract String getEpilog();

    private Writer createWriter() throws IOException {
        Writer writer = NinjaUtils.createWriter((File)((BasicExportOptions)this.options).getOutput(), (Charset)this.context.getCharset(), (boolean)((BasicExportOptions)this.options).isZip(), (boolean)((BasicExportOptions)this.options).isOverwrite(), (PrintStream)this.context.out);
        String prolog = this.getProlog();
        if (prolog != null) {
            writer.write(prolog);
        }
        return writer;
    }

    private void finalizeWriter(Writer writer) throws IOException {
        if (writer == null) {
            return;
        }
        String epilog = this.getEpilog();
        if (epilog != null) {
            writer.write(epilog);
        }
        writer.flush();
    }
}

