/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.BaseOptions;
import com.evolveum.midpoint.ninja.action.UpgradeBaseAction;
import com.evolveum.midpoint.ninja.action.VerifyAction;
import com.evolveum.midpoint.ninja.action.VerifyOptions;
import com.evolveum.midpoint.ninja.action.VerifyResult;
import com.evolveum.midpoint.ninja.action.upgrade.action.PreUpgradeCheckAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.PreUpgradeCheckOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeObjectsAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeObjectsOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeOptions;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.ThrowableSupplier;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class UpgradeAction
extends UpgradeBaseAction<UpgradeOptions, ActionResult<Void>> {
    private static final String VERIFY_OUTPUT_FILE = "verify-output.csv";

    public String getOperationName() {
        return "upgrade";
    }

    private String checkInputOrDefault(ThrowableSupplier<String> inputSupplier, String defaultValue) throws Exception {
        BaseOptions baseOptions = (BaseOptions)this.context.getOptions(BaseOptions.class);
        if (baseOptions.isBatchMode()) {
            return defaultValue;
        }
        return (String)inputSupplier.get();
    }

    private ActionResult<Void> createCanceledResult() {
        return new ActionResult(null, 0, "Process cancelled by user");
    }

    public ActionResult<Void> execute() throws Exception {
        File tempDirectory = this.createTmpDirectory(null);
        PartialActionResult partialVerifyResult = this.startAction("Do you want to run verification before upgrade?", "Skipping objects verification", () -> {
            File verificationFile = new File(tempDirectory, VERIFY_OUTPUT_FILE);
            VerifyOptions verifyOptions = new VerifyOptions();
            verifyOptions.setOutput(verificationFile);
            verifyOptions.setOverwrite(true);
            verifyOptions.setReportStyle(VerifyOptions.ReportStyle.CSV);
            return (VerifyResult)this.executeAction((Action)new VerifyAction(true), (Object)verifyOptions);
        });
        if (partialVerifyResult.canceled) {
            return this.createCanceledResult();
        }
        File verificationFile = partialVerifyResult.result != null ? ((VerifyResult)partialVerifyResult.result).getVerificationFile() : null;
        PartialActionResult partialUpgradeObjectsResult = this.startAction("Do you want to update objects before upgrade?", "Skipping objects upgrade", () -> {
            File finalVerifiactionFile = verificationFile;
            if (finalVerifiactionFile == null) {
                this.log.info("Do you want to provide a file with verification issues? yes/no (y/n) [n] ", new Object[0]);
                String verifyFileResp = this.checkInputOrDefault(() -> NinjaUtils.readInput((Log)this.log, input -> StringUtils.isEmpty((CharSequence)input) || input.matches("[yn]")), "n");
                if ("y".equals(verifyFileResp)) {
                    String filePath = NinjaUtils.readInput((Log)this.log, input -> StringUtils.isNotEmpty((CharSequence)input));
                    finalVerifiactionFile = new File(filePath);
                }
            } else {
                this.checkVerificationReviewed();
            }
            if (finalVerifiactionFile == null) {
                this.log.info("Verification file was not created, nor provided. Ninja will try to update all objects that contain verification issues.Verification issues that were skipped will be reported", new Object[0]);
            }
            UpgradeObjectsOptions upgradeObjectsOptions = new UpgradeObjectsOptions();
            upgradeObjectsOptions.setVerification(finalVerifiactionFile);
            return (ActionResult)this.executeAction((Action)new UpgradeObjectsAction(true), (Object)upgradeObjectsOptions);
        });
        if (partialUpgradeObjectsResult.canceled) {
            return this.createCanceledResult();
        }
        PartialActionResult preUpgradeResult = this.startAction("Do you want to run pre-upgrade checks?", "Skipping pre-upgrade checks", () -> {
            PreUpgradeCheckOptions preUpgradeCheckOptions = new PreUpgradeCheckOptions();
            return (ActionResult)this.executeAction((Action)new PreUpgradeCheckAction(true), (Object)preUpgradeCheckOptions);
        });
        if (preUpgradeResult.canceled) {
            return this.createCanceledResult();
        }
        return null;
    }

    private <T> PartialActionResult<T> startAction(String confirmMessage, String skipMessage, ThrowableSupplier<T> supplier) throws Exception {
        this.log.info("", new Object[0]);
        this.log.info(confirmMessage + " yes/skip/cancel (y/s/C) [y] ", new Object[0]);
        String response = this.checkInputOrDefault(() -> NinjaUtils.readInput((Log)this.log, input -> StringUtils.isEmpty((CharSequence)input) || input.matches("[ysC]")), "y");
        if ("C".equals(response)) {
            return new PartialActionResult(true, response);
        }
        if ("s".equals(response)) {
            this.log.warn(skipMessage, new Object[0]);
            return new PartialActionResult(false, response);
        }
        return new PartialActionResult(false, response, supplier.get());
    }

    private boolean checkVerificationReviewed() throws Exception {
        this.log.info("Have you reviewed verification issues? yes/no (y/n) [y] ", new Object[0]);
        String reviewedVerificationResp = this.checkInputOrDefault(() -> NinjaUtils.readInput((Log)this.log, input -> StringUtils.isEmpty((CharSequence)input) || input.matches("[yn]")), "y");
        if ("n".equals(reviewedVerificationResp)) {
            return this.checkVerificationReviewed();
        }
        return true;
    }
}

