/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.upgrade.ConsoleProgressListener;
import com.evolveum.midpoint.ninja.action.upgrade.DistributionManager;
import com.evolveum.midpoint.ninja.action.upgrade.ProgressListener;
import com.evolveum.midpoint.ninja.action.upgrade.action.DownloadDistributionOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.DownloadDistributionResult;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.fusesource.jansi.Ansi;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadDistributionAction
extends Action<DownloadDistributionOptions, DownloadDistributionResult> {
    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        return NinjaApplicationContextLevel.NONE;
    }

    public String getOperationName() {
        return "download distribution";
    }

    public DownloadDistributionResult execute() throws Exception {
        Log log = this.context.getLog();
        File tempDirectory = ((DownloadDistributionOptions)this.options).getTempDirectory();
        File distributionZipFile = ((DownloadDistributionOptions)this.options).getDistributionArchive();
        if (distributionZipFile == null || !distributionZipFile.exists()) {
            String version = ((DownloadDistributionOptions)this.options).getDistributionVersion();
            if (version == null) {
                throw new IllegalStateException("No version to upgrade to.");
            }
            log.info("Downloading version: {}", new Object[]{version});
            DistributionManager manager = new DistributionManager(tempDirectory);
            ConsoleProgressListener listener = new ConsoleProgressListener(log);
            distributionZipFile = manager.downloadDistribution(version, (ProgressListener)listener);
        } else {
            log.info("Distribution zip already downloaded.", new Object[0]);
        }
        File distributionDirectory = this.unzipDistribution(distributionZipFile);
        log.info(Ansi.ansi().a("Distribution zip: ").a(distributionZipFile.getAbsolutePath()).reset().toString(), new Object[0]);
        log.info(Ansi.ansi().a("Distribution directory: ").a(distributionDirectory.getAbsolutePath()).reset().toString(), new Object[0]);
        return new DownloadDistributionResult(distributionZipFile, distributionDirectory);
    }

    private File unzipDistribution(File distributionZip) throws IOException {
        File distribution;
        File tempDirectory = ((DownloadDistributionOptions)this.options).getTempDirectory();
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(distributionZip));){
            ZipEntry zipEntry = zis.getNextEntry();
            distribution = DownloadDistributionAction.newFile((File)tempDirectory, (ZipEntry)zipEntry);
            if (distribution.exists() && distribution.isDirectory()) {
                FileUtils.deleteDirectory((File)distribution);
            }
            while (zipEntry != null) {
                File newFile = DownloadDistributionAction.newFile((File)tempDirectory, (ZipEntry)zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
        }
        if (((DownloadDistributionOptions)this.options).getDistributionDirectory() != null) {
            File distributionDirectory = ((DownloadDistributionOptions)this.options).getDistributionDirectory();
            return distribution.renameTo(distributionDirectory) ? distributionDirectory : distribution;
        }
        return distribution;
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

