/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining.generator.context;

import com.evolveum.midpoint.ninja.action.mining.generator.GeneratorOptions;
import com.evolveum.midpoint.ninja.action.mining.generator.context.ImportAction;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacBasicStructure;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacGeneratorUtils;
import com.evolveum.midpoint.ninja.action.mining.generator.object.InitialBusinessRole;
import com.evolveum.midpoint.ninja.action.mining.generator.object.InitialObjectsDefinition;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class RbacUserType
implements RbacBasicStructure {
    protected GeneratorOptions generatorOptions;

    public RbacUserType(GeneratorOptions generatorOptions) {
        this.generatorOptions = generatorOptions;
    }

    public UserType build(@NotNull UserType user) {
        List planktonApplicationRoles;
        String title;
        InitialObjectsDefinition.LocationInitialBusinessRole locationRole;
        String birthRole;
        String organizationOid;
        String correspondingArchetypeOid = this.getCorrespondingArchetypeOid();
        if (correspondingArchetypeOid != null) {
            RbacGeneratorUtils.setUpArchetypeUser((UserType)user, (String)correspondingArchetypeOid);
        }
        if ((organizationOid = this.getOrganizationOid()) != null) {
            user.getAssignment().add(RbacGeneratorUtils.createOrgAssignment((String)organizationOid));
        }
        if ((birthRole = this.getBirthRole()) != null) {
            user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)this.getBirthRole()));
        }
        if ((locationRole = this.getLocationRole(true)) != null) {
            user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)locationRole.getOidValue()));
            String locality = this.getLocality();
            if (locality != null) {
                user.setLocality(PolyStringType.fromOrig((String)locality));
            }
        }
        this.additionalChanges(user);
        InitialBusinessRole primaryRole = this.getPrimaryRole(true);
        if (primaryRole != null) {
            user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
        }
        if ((title = this.getTitle()) != null) {
            user.setTitle(PolyStringType.fromOrig((String)title));
        }
        if ((planktonApplicationRoles = this.getPlanktonApplicationRoles()) != null && !planktonApplicationRoles.isEmpty()) {
            for (InitialObjectsDefinition.PlanktonApplicationBusinessAbstractRole planktonApplicationRole : planktonApplicationRoles) {
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)planktonApplicationRole.getOidValue()));
            }
        }
        return user;
    }

    public void buildAndImportObjects(@NotNull Log log, @NotNull RepositoryService repository, @NotNull GeneratorOptions generatorOptions, int total, Set<String> names, @NotNull OperationResult result) {
        String displayName = this.getDisplayName();
        log.info("Importing " + displayName + ": 0/{}", new Object[]{total});
        for (int i = 0; i < total; ++i) {
            log.info("Importing " + displayName + ": {}/{}", new Object[]{i + 1, total});
            UserType user = new UserType();
            user.setName(ImportAction.getNameFromSet((PolyStringType)PolyStringType.fromOrig((String)(displayName + " User " + i)), names));
            user = this.build(user);
            ImportAction.importUserAndResolveAuxRoles((UserType)user, (RepositoryService)repository, (GeneratorOptions)generatorOptions, (OperationResult)result, (Log)log);
        }
    }

    public abstract String getBirthRole();

    public abstract String getOrganizationOid();

    public abstract String getCorrespondingArchetypeOid();

    public abstract InitialBusinessRole getPrimaryRole(boolean var1);

    public abstract InitialObjectsDefinition.LocationInitialBusinessRole getLocationRole(boolean var1);

    public abstract List<InitialObjectsDefinition.PlanktonApplicationBusinessAbstractRole> getPlanktonApplicationRoles();

    public abstract String getLocality();

    public abstract String getTitle();

    protected abstract String getDisplayName();
}

