/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining.generator.context;

import com.evolveum.midpoint.ninja.action.mining.generator.GeneratorOptions;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacGeneratorUtils;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacObjectCategoryBuilder;
import com.evolveum.midpoint.ninja.action.mining.generator.context.RbacObjectCategoryProcessor;
import com.evolveum.midpoint.ninja.action.mining.generator.object.InitialBusinessRole;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class RbacObjectCategoryProcessor {
    public static Category getRandomCategory(Category category) {
        Random random = new Random();
        Category[] values = Category.values();
        Category randomCategory = category;
        while (randomCategory == category) {
            randomCategory = values[random.nextInt(values.length)];
        }
        return randomCategory;
    }

    public static Category getRandomCategory(Category category, Category category2) {
        Random random = new Random();
        Category[] values = Category.values();
        Category randomCategory = category;
        while (randomCategory == category || randomCategory == category2) {
            randomCategory = values[random.nextInt(values.length)];
        }
        return randomCategory;
    }

    public static void generateRbacData(@NotNull RepositoryService repository, @NotNull Category category, @NotNull Log log, @NotNull GeneratorOptions generatorOptions, int total, Set<String> names, OperationResult result) {
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$mining$generator$context$RbacObjectCategoryProcessor$Category[category.ordinal()]) {
            case 1: {
                new RbacObjectCategoryBuilder.RegularUserType(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.REGULR, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 2: {
                new RbacObjectCategoryBuilder.SemiRegularUserType(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.SEMI_REGULAR, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 3: {
                new RbacObjectCategoryBuilder.IrregularUserType(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.IRREGULAR, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 4: {
                new RbacObjectCategoryBuilder.ManagerUserType(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.MANAGERS, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 5: {
                new RbacObjectCategoryBuilder.SalesUserType(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.SALES, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 6: {
                new RbacObjectCategoryBuilder.SecurityOfficer(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.SECURITY_OFFICERS, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
                break;
            }
            case 7: {
                new RbacObjectCategoryBuilder.Contractor(generatorOptions).buildAndImportObjects(log, repository, generatorOptions, total, names, result);
                RbacObjectCategoryProcessor.resolveOutliers((Category)Category.CONTRACTORS, (RepositoryService)repository, (Log)log, (GeneratorOptions)generatorOptions, (int)total, (OperationResult)result);
            }
        }
    }

    private static void resolveOutliers(@NotNull Category category, @NotNull RepositoryService repository, @NotNull Log log, @NotNull GeneratorOptions generatorOptions, int total, OperationResult result) {
        int outlierProbability = generatorOptions.getOutlierProbability();
        if ((double)generatorOptions.getOutlierProbability() != 0.0) {
            int partition = (int)((double)total / 100.0) * outlierProbability;
            int outlierZombieProbability = generatorOptions.getOutlierZombieProbability();
            int outlierMatuzalemProbability = generatorOptions.getOutlierMatuzalemProbability();
            int outlierJumperProbability = generatorOptions.getOutlierJumperProbability();
            int outlierMaskProbability = generatorOptions.getOutlierMaskProbability();
            if (outlierMatuzalemProbability != 0) {
                outlierMatuzalemProbability += outlierZombieProbability;
            }
            if (outlierJumperProbability != 0) {
                outlierJumperProbability += outlierMatuzalemProbability;
            }
            if (outlierMaskProbability != 0) {
                outlierMaskProbability += outlierJumperProbability;
            }
            for (int i = 0; i < partition; ++i) {
                int probabilityPoint = RbacGeneratorUtils.getProbabilityPoint();
                if (outlierZombieProbability != 0 && probabilityPoint <= outlierZombieProbability) {
                    new RbacObjectCategoryBuilder.OutlierZombie(category).buildAndImport(log, repository, generatorOptions, i, result);
                    continue;
                }
                if (outlierMatuzalemProbability != 0 && probabilityPoint <= outlierMatuzalemProbability) {
                    new RbacObjectCategoryBuilder.OutlierMatuzalem(category).buildAndImport(log, repository, generatorOptions, i, result);
                    continue;
                }
                if (outlierJumperProbability != 0 && probabilityPoint <= outlierJumperProbability) {
                    new RbacObjectCategoryBuilder.OutlierJumper(category).buildAndImport(log, repository, generatorOptions, i, result);
                    continue;
                }
                if (outlierMaskProbability == 0 || probabilityPoint > outlierMaskProbability) continue;
                new RbacObjectCategoryBuilder.OutlierMask(category).buildAndImport(log, repository, generatorOptions, i, result);
            }
            boolean candidate = RbacGeneratorUtils.isCandidate((int)generatorOptions.getOutlierProbability());
            if (candidate) {
                new RbacObjectCategoryBuilder.OutlierMask(category).buildAndImport(log, repository, generatorOptions, total, result);
            }
            if (candidate = RbacGeneratorUtils.isCandidate((int)generatorOptions.getOutlierProbability())) {
                new RbacObjectCategoryBuilder.OutlierMatuzalem(category).buildAndImport(log, repository, generatorOptions, total, result);
            }
            if (candidate = RbacGeneratorUtils.isCandidate((int)generatorOptions.getOutlierProbability())) {
                new RbacObjectCategoryBuilder.OutlierJumper(category).buildAndImport(log, repository, generatorOptions, total, result);
            }
            if (candidate = RbacGeneratorUtils.isCandidate((int)generatorOptions.getOutlierProbability())) {
                new RbacObjectCategoryBuilder.OutlierZombie(category).buildAndImport(log, repository, generatorOptions, total, result);
            }
        }
    }

    public static void generateRbacObject(@NotNull UserType user, @NotNull Category category, @NotNull GeneratorOptions generatorOptions) {
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$mining$generator$context$RbacObjectCategoryProcessor$Category[category.ordinal()]) {
            case 1: {
                new RbacObjectCategoryBuilder.RegularUserType(generatorOptions).build(user);
                break;
            }
            case 2: {
                new RbacObjectCategoryBuilder.SemiRegularUserType(generatorOptions).build(user);
                break;
            }
            case 3: {
                new RbacObjectCategoryBuilder.IrregularUserType(generatorOptions).build(user);
                break;
            }
            case 4: {
                new RbacObjectCategoryBuilder.ManagerUserType(generatorOptions).build(user);
                break;
            }
            case 5: {
                new RbacObjectCategoryBuilder.SalesUserType(generatorOptions).build(user);
                break;
            }
            case 6: {
                new RbacObjectCategoryBuilder.SecurityOfficer(generatorOptions).build(user);
                break;
            }
            case 7: {
                new RbacObjectCategoryBuilder.Contractor(generatorOptions).build(user);
            }
        }
    }

    @Nullable
    public static String retrieveOrgUnit(@NotNull GeneratorOptions generatorOptions, @NotNull Category category) {
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$mining$generator$context$RbacObjectCategoryProcessor$Category[category.ordinal()]) {
            case 1: {
                return new RbacObjectCategoryBuilder.RegularUserType(generatorOptions).getOrganizationOid();
            }
            case 2: {
                return new RbacObjectCategoryBuilder.SemiRegularUserType(generatorOptions).getOrganizationOid();
            }
            case 3: {
                return new RbacObjectCategoryBuilder.IrregularUserType(generatorOptions).getOrganizationOid();
            }
            case 4: {
                return new RbacObjectCategoryBuilder.ManagerUserType(generatorOptions).getOrganizationOid();
            }
            case 5: {
                return new RbacObjectCategoryBuilder.SalesUserType(generatorOptions).getOrganizationOid();
            }
            case 6: {
                return new RbacObjectCategoryBuilder.SecurityOfficer(generatorOptions).getOrganizationOid();
            }
            case 7: {
                return new RbacObjectCategoryBuilder.Contractor(generatorOptions).getOrganizationOid();
            }
        }
        return null;
    }

    public static void assignPrimaryAccessByCategory(@NotNull UserType user, @NotNull Category category, @NotNull GeneratorOptions generatorOptions) {
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$mining$generator$context$RbacObjectCategoryProcessor$Category[category.ordinal()]) {
            case 1: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.RegularUserType(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 2: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.SemiRegularUserType(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 3: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.IrregularUserType(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 4: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.ManagerUserType(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 5: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.SalesUserType(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 6: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.SecurityOfficer(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
                break;
            }
            case 7: {
                InitialBusinessRole primaryRole = new RbacObjectCategoryBuilder.Contractor(generatorOptions).getPrimaryRole(true);
                user.getAssignment().add(RbacGeneratorUtils.createRoleAssignment((String)primaryRole.getOidValue()));
            }
        }
    }
}

