/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining;

import com.evolveum.midpoint.common.RoleMiningExportUtils;
import com.evolveum.midpoint.common.mining.utils.RoleAnalysisAttributeDefUtils;
import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.mining.ExportMiningOptions;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismItemBasicDefinition;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.security.api.MidPointPrincipalManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ExtensionType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.FocusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import com.evolveum.prism.xml.ns._public.types_3.RawType;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportMiningConsumerWorker
extends AbstractWriterConsumerWorker<ExportMiningOptions, FocusType> {
    OperationResult operationResult = new OperationResult(MidPointPrincipalManager.DOT_CLASS + "searchObjectByCondition");
    private PrismSerializer<String> serializer;
    private int processedRoleIterator = 0;
    private int processedUserIterator = 0;
    private int processedOrgIterator = 0;
    private final RoleMiningExportUtils.SequentialAnonymizer defaultAttributeNameAnonymizer = new RoleMiningExportUtils.SequentialAnonymizer("default_attr");
    private final RoleMiningExportUtils.SequentialAnonymizer extensionAttributeNameAnonymizer = new RoleMiningExportUtils.SequentialAnonymizer("extension_attr");
    private RoleMiningExportUtils.AttributeValueAnonymizer attributeValuesAnonymizer;
    private boolean orgAllowed;
    private boolean attributesAllowed;
    private boolean firstObject = true;
    private boolean jsonFormat = false;
    private RoleMiningExportUtils.SecurityMode securityMode;
    private RoleMiningExportUtils.NameMode nameMode;
    private String encryptKey;
    private ObjectFilter filterRole;
    private ObjectFilter filterOrg;
    private static String applicationArchetypeOid;
    private static String businessArchetypeOid;
    private List<String> applicationRolePrefix;
    private List<String> applicationRoleSuffix;
    private List<String> businessRolePrefix;
    private List<String> businessRoleSuffix;
    private Set<ItemName> attrPathsUser;
    private Set<ItemName> attrPathsRole;
    private Set<ItemName> attrPathsOrg;
    private static final String ARCHETYPE_REF_ATTRIBUTE_NAME = "archetypeRef";
    private static final List<String> DEFAULT_EXCLUDED_ATTRIBUTES;

    public ExportMiningConsumerWorker(NinjaContext context, ExportMiningOptions options, BlockingQueue<FocusType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
    }

    protected void init() {
        this.loadFilters(((ExportMiningOptions)this.options).getRoleFilter(), ((ExportMiningOptions)this.options).getOrgFilter());
        this.loadRoleCategoryIdentifiers();
        this.securityMode = ((ExportMiningOptions)this.options).getSecurityLevel();
        this.encryptKey = RoleMiningExportUtils.updateEncryptKey((RoleMiningExportUtils.SecurityMode)this.securityMode);
        this.orgAllowed = ((ExportMiningOptions)this.options).isIncludeOrg();
        this.attributesAllowed = ((ExportMiningOptions)this.options).isIncludeAttributes();
        this.nameMode = ((ExportMiningOptions)this.options).getNameMode();
        this.attrPathsUser = this.extractDefaultAttributePaths(UserType.COMPLEX_TYPE, ((ExportMiningOptions)this.options).getExcludedAttributesUser());
        this.attrPathsRole = this.extractDefaultAttributePaths(RoleType.COMPLEX_TYPE, ((ExportMiningOptions)this.options).getExcludedAttributesRole());
        this.attrPathsOrg = this.extractDefaultAttributePaths(OrgType.COMPLEX_TYPE, ((ExportMiningOptions)this.options).getExcludedAttributesOrg());
        this.attributeValuesAnonymizer = new RoleMiningExportUtils.AttributeValueAnonymizer(this.nameMode, this.encryptKey);
        SerializationOptions serializationOptions = SerializationOptions.createSerializeForExport().serializeReferenceNames(true).serializeForExport(true).skipContainerIds(true);
        this.jsonFormat = ((ExportMiningOptions)this.options).getOutput().getName().endsWith(".json");
        this.serializer = this.jsonFormat ? this.context.getPrismContext().jsonSerializer().options(serializationOptions) : this.context.getPrismContext().xmlSerializer().options(serializationOptions);
    }

    protected String getProlog() {
        if (this.jsonFormat) {
            return "[\n";
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<c:objects xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:org=\"http://midpoint.evolveum.com/xml/ns/public/common/org-3\">\n";
    }

    protected String getEpilog() {
        if (this.jsonFormat) {
            return "\n]";
        }
        return "</c:objects>\n";
    }

    protected void write(Writer writer, @NotNull FocusType object) throws SchemaException, IOException {
        if (object.asPrismObject().isOfType(RoleType.class)) {
            RoleType role = this.getPreparedRoleObject(object);
            this.write(writer, role.asPrismContainerValue());
        } else if (object.asPrismObject().isOfType(UserType.class)) {
            UserType user = this.getPreparedUserObject(object);
            if (user.getAssignment() != null && !user.getAssignment().isEmpty()) {
                this.write(writer, user.asPrismContainerValue());
            }
        } else if (object.asPrismObject().isOfType(OrgType.class)) {
            OrgType org = this.getPreparedOrgObject(object);
            this.write(writer, org.asPrismContainerValue());
        }
    }

    private void write(Writer writer, PrismContainerValue<?> prismContainerValue) throws SchemaException, IOException {
        String xml = (String)this.serializer.serialize(prismContainerValue);
        if (this.jsonFormat && !this.firstObject) {
            writer.write(",\n" + xml);
        } else {
            writer.write(xml);
        }
        this.firstObject = false;
    }

    @NotNull
    private OrgType getPreparedOrgObject(@NotNull FocusType object) {
        OrgType org = new OrgType();
        this.fillAttributes(object, (FocusType)org, this.attrPathsOrg, ((ExportMiningOptions)this.options).getExcludedAttributesOrg());
        this.fillActivation(object, (FocusType)org);
        org.setName(RoleMiningExportUtils.encryptOrgName((String)object.getName().toString(), (int)this.processedOrgIterator++, (RoleMiningExportUtils.NameMode)this.nameMode, (String)this.encryptKey));
        org.setOid(RoleMiningExportUtils.encryptedUUID((String)object.getOid(), (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        List assignment = object.getAssignment();
        for (AssignmentType assignmentObject : assignment) {
            ObjectReferenceType targetRef = assignmentObject.getTargetRef();
            if (targetRef == null) continue;
            String objectType = this.getObjectType(targetRef);
            String oid = targetRef.getOid();
            if (objectType == null || oid == null || !objectType.equals(OrgType.class.getSimpleName()) || !this.filterAllowedOrg(oid)) continue;
            org.getAssignment().add(RoleMiningExportUtils.encryptObjectReference((AssignmentType)assignmentObject, (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        }
        return org;
    }

    @NotNull
    private UserType getPreparedUserObject(@NotNull FocusType object) {
        UserType user = new UserType();
        this.fillAttributes(object, (FocusType)user, this.attrPathsUser, ((ExportMiningOptions)this.options).getExcludedAttributesUser());
        this.fillActivation(object, (FocusType)user);
        List assignment = object.getAssignment();
        if (assignment == null || assignment.isEmpty()) {
            return new UserType();
        }
        for (AssignmentType assignmentObject : assignment) {
            ObjectReferenceType targetRef = assignmentObject.getTargetRef();
            if (targetRef == null) continue;
            String objectType = this.getObjectType(targetRef);
            String oid = targetRef.getOid();
            if (objectType == null || oid == null) continue;
            if (objectType.equals(RoleType.class.getSimpleName()) && this.filterAllowedRole(oid)) {
                user.getAssignment().add(RoleMiningExportUtils.encryptObjectReference((AssignmentType)assignmentObject, (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
            }
            if (!this.orgAllowed || !objectType.equals(OrgType.class.getSimpleName()) || !this.filterAllowedOrg(oid)) continue;
            user.getAssignment().add(RoleMiningExportUtils.encryptObjectReference((AssignmentType)assignmentObject, (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        }
        user.setName(RoleMiningExportUtils.encryptUserName((String)object.getName().toString(), (int)this.processedUserIterator++, (RoleMiningExportUtils.NameMode)this.nameMode, (String)this.encryptKey));
        user.setOid(RoleMiningExportUtils.encryptedUUID((String)object.getOid(), (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        return user;
    }

    @NotNull
    private RoleType getPreparedRoleObject(@NotNull FocusType object) {
        RoleType role = new RoleType();
        this.fillAttributes(object, (FocusType)role, this.attrPathsRole, ((ExportMiningOptions)this.options).getExcludedAttributesRole());
        this.fillActivation(object, (FocusType)role);
        String roleName = object.getName().toString();
        PolyStringType encryptedName = RoleMiningExportUtils.encryptRoleName((String)roleName, (int)this.processedRoleIterator++, (RoleMiningExportUtils.NameMode)this.nameMode, (String)this.encryptKey);
        role.setName(encryptedName);
        role.setOid(RoleMiningExportUtils.encryptedUUID((String)object.getOid(), (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        String identifier = "";
        List inducement = ((RoleType)object).getInducement();
        for (Object inducementObject : inducement) {
            ObjectReferenceType targetRef = inducementObject.getTargetRef();
            if (targetRef == null) continue;
            String objectType = this.getObjectType(targetRef);
            String oid = targetRef.getOid();
            if (objectType == null || oid == null || !objectType.equals(RoleType.class.getSimpleName()) || !this.filterAllowedRole(oid)) continue;
            role.getInducement().add(RoleMiningExportUtils.encryptObjectReference((AssignmentType)inducementObject, (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey));
        }
        List assignment = object.getAssignment();
        for (AssignmentType assignmentObject : assignment) {
            ObjectReferenceType targetRef = assignmentObject.getTargetRef();
            if (targetRef == null) continue;
            String objectType = this.getObjectType(targetRef);
            String oid = targetRef.getOid();
            if (objectType == null || oid == null || !objectType.equals(ArchetypeType.class.getSimpleName())) continue;
            AssignmentType assignmentType = new AssignmentType();
            if (oid.equals(applicationArchetypeOid)) {
                identifier = "Application role";
                assignmentType.targetRef(targetRef);
                role.getAssignment().add(assignmentType);
                continue;
            }
            if (!oid.equals(businessArchetypeOid)) continue;
            identifier = "Business role";
            assignmentType.targetRef(targetRef);
            role.getAssignment().add(assignmentType);
        }
        if (!identifier.isEmpty()) {
            role.setIdentifier(identifier);
        } else {
            String prefixCheckedIdentifier = RoleMiningExportUtils.determineRoleCategory((String)roleName, (List)this.applicationRolePrefix, (List)this.businessRolePrefix, (List)this.applicationRoleSuffix, (List)this.businessRoleSuffix);
            if (prefixCheckedIdentifier != null) {
                role.setIdentifier(prefixCheckedIdentifier);
            }
        }
        return role;
    }

    private boolean filterAllowedOrg(String oid) {
        if (this.filterOrg == null) {
            return true;
        }
        ObjectQuery objectQuery = this.context.getPrismContext().queryFactory().createQuery(this.filterOrg);
        objectQuery.addFilter(this.context.getPrismContext().queryFor(OrgType.class).id(new String[]{oid}).buildFilter());
        try {
            return !this.context.getRepository().searchObjects(OrgType.class, objectQuery, null, this.operationResult).isEmpty();
        }
        catch (SchemaException e) {
            this.context.getLog().error("Failed to search organization object. ", (Exception)((Object)e), new Object[0]);
            return false;
        }
    }

    private boolean filterAllowedRole(String oid) {
        if (this.filterRole == null) {
            return true;
        }
        ObjectQuery objectQuery = this.context.getPrismContext().queryFactory().createQuery(this.filterRole);
        objectQuery.addFilter(this.context.getPrismContext().queryFor(RoleType.class).id(new String[]{oid}).buildFilter());
        try {
            return !this.context.getRepository().searchObjects(RoleType.class, objectQuery, null, this.operationResult).isEmpty();
        }
        catch (SchemaException e) {
            this.context.getLog().error("Failed to search role object. ", (Exception)((Object)e), new Object[0]);
            return false;
        }
    }

    private void loadFilters(FileReference roleFileReference, FileReference orgFileReference) {
        try {
            this.filterRole = NinjaUtils.createObjectFilter((FileReference)roleFileReference, (NinjaContext)this.context, RoleType.class);
            this.filterOrg = NinjaUtils.createObjectFilter((FileReference)orgFileReference, (NinjaContext)this.context, OrgType.class);
        }
        catch (SchemaException | IOException e) {
            this.context.getLog().error("Failed to crate object filter. ", (Exception)e, new Object[0]);
        }
    }

    private void loadRoleCategoryIdentifiers() {
        applicationArchetypeOid = ((ExportMiningOptions)this.options).getApplicationRoleArchetypeOid();
        businessArchetypeOid = ((ExportMiningOptions)this.options).getBusinessRoleArchetypeOid();
        this.applicationRolePrefix = ((ExportMiningOptions)this.options).getApplicationRolePrefix();
        this.applicationRoleSuffix = ((ExportMiningOptions)this.options).getApplicationRoleSuffix();
        this.businessRolePrefix = ((ExportMiningOptions)this.options).getBusinessRolePrefix();
        this.businessRoleSuffix = ((ExportMiningOptions)this.options).getBusinessRoleSuffix();
    }

    @Nullable
    private String getObjectType(@NotNull ObjectReferenceType targetRef) {
        QName type = targetRef.getType();
        if (type != null) {
            return type.getLocalPart();
        }
        return null;
    }

    private boolean filterSupportedAttribute(ItemDefinition<?> def, ItemName itemName, List<String> excludedAttributeNames) {
        PrismPropertyDefinition propertyDef;
        String attributeName = itemName.toString();
        if (excludedAttributeNames.contains(attributeName)) {
            return false;
        }
        if (def == null) {
            return true;
        }
        if (def.getTypeClass() == null) {
            return false;
        }
        boolean isArchetypeRef = attributeName.equals(ARCHETYPE_REF_ATTRIBUTE_NAME);
        if (!(isArchetypeRef || !def.isOperational() && def.isSingleValue())) {
            return false;
        }
        if (def instanceof PrismReferenceDefinition) {
            return true;
        }
        return def instanceof PrismPropertyDefinition && RoleAnalysisAttributeDefUtils.isSupportedPropertyType((Class)(propertyDef = (PrismPropertyDefinition)def).getTypeClass());
    }

    private Set<ItemName> extractDefaultAttributePaths(QName type, List<String> excludedDefaultAttributes) {
        PrismContainerDefinition containerDef = PrismContext.get().getSchemaRegistry().findContainerDefinitionByType(type);
        List excludedAttributes = Stream.concat(excludedDefaultAttributes.stream(), DEFAULT_EXCLUDED_ATTRIBUTES.stream()).toList();
        return containerDef.getDefinitions().stream().filter(def -> this.filterSupportedAttribute(def, def.getItemName(), excludedAttributes)).map(PrismItemBasicDefinition::getItemName).collect(Collectors.toUnmodifiableSet());
    }

    private Set<ItemName> extractExtensionAttributePaths(PrismContainerValue<?> containerValue, List<String> excludedAttributeNames) {
        return containerValue.getItems().stream().filter(item -> this.filterSupportedAttribute(item.getDefinition(), item.getElementName(), excludedAttributeNames)).map(Item::getElementName).collect(Collectors.toUnmodifiableSet());
    }

    private Object tryParseUnknownValue(RawType raw, Class<?> clazz) {
        try {
            return Objects.requireNonNull(raw).getParsedRealValue(clazz);
        }
        catch (SchemaException e) {
            return null;
        }
    }

    private Object parseRealValue(Item<?, ?> item) {
        if (item.hasCompleteDefinition()) {
            return Objects.requireNonNull(item.getRealValue());
        }
        RawType rawValue = (RawType)item.getAnyValue().getRealValue();
        for (Class<ObjectReferenceType> possibleClass : List.of(String.class, PolyStringType.class, ObjectReferenceType.class)) {
            Object result = this.tryParseUnknownValue(rawValue, possibleClass);
            if (result == null) continue;
            return result;
        }
        throw new RuntimeException("Cannot parse attribute value: " + item.getElementName());
    }

    private Object anonymizeAttributeValue(Item<?, ?> item, ItemName itemName) {
        Object realValue = this.parseRealValue(item);
        Class<?> typeClass = realValue.getClass();
        String attributeName = itemName.toString();
        if (ObjectReferenceType.class.equals(typeClass)) {
            ObjectReferenceType referenceValue = (ObjectReferenceType)realValue;
            return RoleMiningExportUtils.encryptObjectReference((ObjectReferenceType)referenceValue, (RoleMiningExportUtils.SecurityMode)this.securityMode, (String)this.encryptKey);
        }
        boolean isOrdinalValue = List.of(Integer.class, Long.class, Double.class).contains(typeClass);
        if (!((ExportMiningOptions)this.options).isAnonymizeOrdinalAttributeValues().booleanValue() && isOrdinalValue) {
            return realValue;
        }
        return this.attributeValuesAnonymizer.anonymize(attributeName, realValue.toString());
    }

    public String anonymizeAttributeName(Item<?, ?> item, RoleMiningExportUtils.SequentialAnonymizer attributeNameAnonymizer) {
        String originalAttributeName = item.getElementName().toString();
        if (this.nameMode.equals((Object)RoleMiningExportUtils.NameMode.ORIGINAL)) {
            return originalAttributeName;
        }
        return attributeNameAnonymizer.anonymize(originalAttributeName);
    }

    private void anonymizeAttribute(FocusType newObject, PrismContainer<?> itemContainer, ItemName itemName, RoleMiningExportUtils.SequentialAnonymizer attributeNameAnonymizer) {
        Item item = itemContainer.findItem((ItemPath)itemName);
        try {
            if (item == null || item.hasNoValues()) {
                return;
            }
            String attributeName = ((ExportMiningOptions)this.options).isAnonymizeAttributeNames() != false ? this.anonymizeAttributeName(item, attributeNameAnonymizer) : item.getElementName().toString();
            Object anonymizedAttributeValue = this.anonymizeAttributeValue(item, itemName);
            QName propertyName = new QName(itemName.getNamespaceURI(), attributeName);
            PrismPropertyDefinition propertyDefinition = this.context.getPrismContext().definitionFactory().newPropertyDefinition(propertyName, DOMUtil.XSD_STRING);
            PrismProperty anonymizedProperty = (PrismProperty)propertyDefinition.instantiate();
            anonymizedProperty.setRealValue(anonymizedAttributeValue);
            newObject.asPrismObject().addExtensionItem((Item)anonymizedProperty);
        }
        catch (Exception e) {
            this.context.getLog().warn("Failed to anonymize attribute: \n{}\n{}\n{}", new Object[]{e, itemName, item});
        }
    }

    private void fillAttributes(@NotNull FocusType origObject, @NotNull FocusType newObject, @NotNull Set<ItemName> defaultAttributePaths, @NotNull List<String> excludedAttributes) {
        if (!this.attributesAllowed) {
            return;
        }
        PrismObject origContainer = origObject.asPrismObject();
        newObject.extension(new ExtensionType());
        for (ItemName path : defaultAttributePaths) {
            this.anonymizeAttribute(newObject, (PrismContainer)origContainer, path, this.defaultAttributeNameAnonymizer);
        }
        if (origContainer.getExtension() != null) {
            Set extensionAttributePaths = this.extractExtensionAttributePaths(origContainer.getExtensionContainerValue(), excludedAttributes);
            for (ItemName path : extensionAttributePaths) {
                this.anonymizeAttribute(newObject, origContainer.getExtension(), path, this.extensionAttributeNameAnonymizer);
            }
        }
    }

    private void fillActivation(@NotNull FocusType origObject, @NotNull FocusType newObject) {
        if (origObject.getActivation() == null) {
            return;
        }
        ActivationType activation = new ActivationType().effectiveStatus(origObject.getActivation().getEffectiveStatus());
        newObject.setActivation(activation);
    }

    static {
        DEFAULT_EXCLUDED_ATTRIBUTES = List.of("description", "documentation", "emailAddress", "telephoneNumber", "name", "fullName", "givenName", "familyName", "additionalName", "nickName", "personalNumber", "identifier", "jpegPhoto");
    }
}

