/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.audit.BaseAuditImportExportOptions;
import com.evolveum.midpoint.ninja.action.audit.ExportAuditConsumerWorker;
import com.evolveum.midpoint.ninja.action.audit.ExportAuditOptions;
import com.evolveum.midpoint.ninja.action.audit.ExportAuditProducerWorker;
import com.evolveum.midpoint.ninja.action.worker.ProgressReporterWorker;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.prism.query.QueryFactory;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ExportAuditRepositoryAction
extends RepositoryAction<ExportAuditOptions, Void> {
    private static final int QUEUE_CAPACITY_PER_THREAD = 100;
    private static final long CONSUMERS_WAIT_FOR_START = 2000L;
    public static final String OPERATION_SHORT_NAME = "exportAudit";
    public static final String OPERATION_NAME = ExportAuditRepositoryAction.class.getName() + ".exportAudit";

    public String getOperationName() {
        return "export audit";
    }

    protected Runnable createConsumer(BlockingQueue<AuditEventRecordType> queue, OperationStatus operation) {
        return new ExportAuditConsumerWorker(this.context, (ExportAuditOptions)this.options, queue, operation);
    }

    public Void execute() throws Exception {
        OperationResult result = new OperationResult(OPERATION_NAME);
        OperationStatus operation = new OperationStatus(this.context, result);
        ExecutorService executor = Executors.newFixedThreadPool(((ExportAuditOptions)this.options).getMultiThread() + 2);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(100 * ((ExportAuditOptions)this.options).getMultiThread());
        List producers = this.createProducers(queue, operation);
        this.log.info("Starting exportAudit", new Object[0]);
        operation.start();
        for (int i = 0; i < producers.size() && i < ((ExportAuditOptions)this.options).getMultiThread(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        Thread.sleep(2000L);
        executor.execute((Runnable)new ProgressReporterWorker(this.context, this.options, queue, operation));
        Runnable consumer = this.createConsumer(queue, operation);
        executor.execute(consumer);
        for (int i = ((ExportAuditOptions)this.options).getMultiThread(); i < producers.size(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        executor.shutdown();
        boolean awaitResult = executor.awaitTermination(365L, TimeUnit.DAYS);
        if (!awaitResult) {
            this.log.error("Executor did not finish before timeout", new Object[0]);
        }
        this.handleResultOnFinish(null, operation, "Finished exportAudit");
        return null;
    }

    public LogTarget getLogTarget() {
        if (((ExportAuditOptions)this.options).getOutput() != null) {
            return LogTarget.SYSTEM_OUT;
        }
        return LogTarget.SYSTEM_ERR;
    }

    private List<ExportAuditProducerWorker> createProducers(BlockingQueue<AuditEventRecordType> queue, OperationStatus operation) throws SchemaException, IOException {
        QueryFactory queryFactory = this.context.getPrismContext().queryFactory();
        ArrayList<ExportAuditProducerWorker> producers = new ArrayList<ExportAuditProducerWorker>();
        ObjectFilter filter = NinjaUtils.createObjectFilter((FileReference)((ExportAuditOptions)this.options).getFilter(), (NinjaContext)this.context, AuditEventRecordType.class);
        ObjectQuery query = queryFactory.createQuery(filter);
        producers.add(new ExportAuditProducerWorker(this.context, (BaseAuditImportExportOptions)this.options, queue, operation, producers, query));
        return producers;
    }
}

