/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ListKeysOptions;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.prism.crypto.EncryptionException;
import com.evolveum.midpoint.prism.crypto.KeyStoreBasedProtector;
import com.evolveum.midpoint.prism.crypto.Protector;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

public class ListKeysRepositoryAction
extends Action<ListKeysOptions, Void> {
    private static final String KEY_DIGEST_TYPE = "SHA1";

    public String getOperationName() {
        return "list keys";
    }

    public LogTarget getLogTarget() {
        return LogTarget.SYSTEM_ERR;
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        return NinjaApplicationContextLevel.NO_REPOSITORY;
    }

    public Void execute() throws Exception {
        ApplicationContext appContext = this.context.getApplicationContext();
        Protector protector = (Protector)appContext.getBean(Protector.class);
        if (protector instanceof KeyStoreBasedProtector) {
            KeyStoreBasedProtector p = (KeyStoreBasedProtector)protector;
            this.context.out.println("Location: " + p.getKeyStorePath());
        }
        KeyStore keyStore = protector.getKeyStore();
        this.context.out.println("Type: " + keyStore.getType());
        Provider provider = keyStore.getProvider();
        this.context.out.println("Provider: " + provider.getName());
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            this.context.out.println("======");
            this.describeAlias(keyStore, alias, protector);
            if (!aliases.hasMoreElements()) continue;
            this.context.out.println("======");
        }
        return null;
    }

    private void describeAlias(KeyStore keyStore, String alias, Protector protector) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, EncryptionException {
        char[] password;
        KeyStore.PasswordProtection protParam;
        KeyStore.Entry entry;
        Certificate[] chain;
        this.context.out.println("Alias: " + alias);
        this.context.out.println("Creation date: " + keyStore.getCreationDate(alias));
        Certificate cert = keyStore.getCertificate(alias);
        if (cert != null) {
            this.context.out.println("Certificate: " + cert);
        }
        if ((chain = keyStore.getCertificateChain(alias)) != null) {
            this.context.out.println("Certificate chain: " + chain);
        }
        if (!((entry = keyStore.getEntry(alias, protParam = new KeyStore.PasswordProtection(password = this.getPassword()))) instanceof KeyStore.SecretKeyEntry)) {
            return;
        }
        KeyStore.SecretKeyEntry sEntry = (KeyStore.SecretKeyEntry)entry;
        SecretKey key = sEntry.getSecretKey();
        this.context.out.println("Secret key entry");
        this.context.out.println("  Algorithm: " + key.getAlgorithm());
        this.context.out.println("  Format: " + key.getFormat());
        this.context.out.println("  Key length: " + key.getEncoded().length * 8);
        this.context.out.println("  SHA1 digest: " + this.getSecretKeyDigest(key));
        if (protector instanceof KeyStoreBasedProtector) {
            KeyStoreBasedProtector impl = (KeyStoreBasedProtector)protector;
            String name = impl.getSecretKeyDigest(key);
            this.context.out.println("  Key name: " + name);
        }
    }

    private char[] getPassword() {
        String password = ((ListKeysOptions)this.options).getKeyPassword();
        if (password == null) {
            password = ((ListKeysOptions)this.options).getAskKeyPassword();
        }
        if (password == null) {
            password = "";
        }
        return password.toCharArray();
    }

    private String getSecretKeyDigest(SecretKey key) throws NinjaException {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance(KEY_DIGEST_TYPE);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NinjaException(ex.getMessage(), (Throwable)ex);
        }
        return Base64.encodeBase64String((byte[])sha1.digest(key.getEncoded()));
    }
}

