/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.ExportShadowStatisticsOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.stats.MagnitudeCounter;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.repo.api.AggregateQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.SearchResultList;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.GenericObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ShadowType;
import java.io.File;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;

public class ExportShadowStatisticsAction
extends RepositoryAction<ExportShadowStatisticsOptions, Void> {
    private static final ItemName F_CORRELATION_SITUATION = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "correlationSituation");
    private static final ItemName F_COUNT = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "count");
    private static final ItemName F_SHADOW_STATISTICS = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "shadowStatistics");

    public String getOperationName() {
        return "export-statistics";
    }

    public Void execute() throws Exception {
        RepositoryService repository = this.context.getRepository();
        FileReference fileReference = ((ExportShadowStatisticsOptions)this.options).getFilter();
        if (fileReference != null && ((ExportShadowStatisticsOptions)this.options).getFilter() == null) {
            throw new NinjaException("Type must be defined");
        }
        boolean total = false;
        OperationResult result = new OperationResult("Shadow Statistics");
        ObjectTypes type = ObjectTypes.SHADOW;
        ObjectQuery shadowQuery = NinjaUtils.createObjectQuery((FileReference)((ExportShadowStatisticsOptions)this.options).getFilter(), (NinjaContext)this.context, ShadowType.class);
        AggregateQuery query = AggregateQuery.forType(ShadowType.class).retrieve(ShadowType.F_RESOURCE_REF).retrieve(ShadowType.F_OBJECT_CLASS).retrieve(ShadowType.F_KIND).retrieve(ShadowType.F_INTENT).retrieve(ShadowType.F_SYNCHRONIZATION_SITUATION).count(F_COUNT, (ItemPath)ShadowType.F_RESOURCE_REF);
        if (shadowQuery != null) {
            query = query.filter(shadowQuery.getFilter());
        }
        SearchResultList results = repository.searchAggregate(query, result);
        Writer writer = NinjaUtils.createWriter((File)((ExportShadowStatisticsOptions)this.options).getOutput(), (Charset)this.context.getCharset(), (boolean)((ExportShadowStatisticsOptions)this.options).isZip(), (boolean)((ExportShadowStatisticsOptions)this.options).isOverwrite(), (PrintStream)this.context.out);
        PrismContainer wrapper = this.context.getPrismContext().itemFactory().createContainer((QName)F_SHADOW_STATISTICS);
        for (PrismContainerValue prismContainerValue : results) {
            try {
                PrismProperty count = prismContainerValue.findProperty((ItemPath)new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "count"));
                long orderOfMagnitude = new MagnitudeCounter(Math.toIntExact((Long)count.getRealValue(Long.class))).toOrderOfMagnitude();
                count.setRealValue((Object)orderOfMagnitude);
                wrapper.addIgnoringEquivalents((PrismValue)prismContainerValue);
            }
            catch (SchemaException e) {
                this.log.error("Couldn't add shadow statistics", (Exception)((Object)e), new Object[0]);
            }
        }
        GenericObjectType obj = new GenericObjectType();
        obj.asPrismObject().findOrCreateContainer((ItemPath)GenericObjectType.F_EXTENSION).add((Item)wrapper);
        PrismSerializer serializer = this.context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport());
        writer.write((String)serializer.serialize((Item)obj.asPrismObject()));
        writer.flush();
        return null;
    }
}

