/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.worker.ProgressReporterWorker;
import com.evolveum.midpoint.ninja.action.worker.SearchProducerWorker;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.query.InOidFilter;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.prism.query.OrFilter;
import com.evolveum.midpoint.prism.query.QueryFactory;
import com.evolveum.midpoint.prism.query.RefFilter;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.GetOperationOptions;
import com.evolveum.midpoint.schema.SearchResultList;
import com.evolveum.midpoint.schema.SelectorOptions;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ShadowType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;

public abstract class AbstractRepositorySearchAction<O extends ExportOptions, R>
extends RepositoryAction<O, R> {
    private static final String DOT_CLASS = AbstractRepositorySearchAction.class.getName() + ".";
    private static final String OPERATION_LIST_RESOURCES = DOT_CLASS + "listResources";
    private static final int QUEUE_CAPACITY_PER_THREAD = 100;
    private static final long CONSUMERS_WAIT_FOR_START = 2000L;

    public AbstractRepositorySearchAction() {
    }

    public AbstractRepositorySearchAction(boolean partial) {
        super(partial);
    }

    protected abstract Callable<R> createConsumer(BlockingQueue<ObjectType> var1, OperationStatus var2);

    public R execute() throws Exception {
        OperationResult result = new OperationResult(this.getClass().getName());
        OperationStatus operation = new OperationStatus(this.context, result);
        ExecutorService executor = Executors.newFixedThreadPool(((ExportOptions)this.options).getMultiThread() + 2);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(100 * ((ExportOptions)this.options).getMultiThread());
        this.context.getResourceSchemaRegistry();
        List producers = this.createProducers(queue, operation);
        operation.start();
        for (int i = 0; i < producers.size() && i < ((ExportOptions)this.options).getMultiThread(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        Thread.sleep(2000L);
        executor.execute((Runnable)new ProgressReporterWorker(this.context, this.options, queue, operation));
        Callable consumer = this.createConsumer(queue, operation);
        Future consumerFuture = executor.submit(consumer);
        for (int i = ((ExportOptions)this.options).getMultiThread(); i < producers.size(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        executor.shutdown();
        boolean awaitResult = executor.awaitTermination(365L, TimeUnit.DAYS);
        if (!awaitResult) {
            this.log.error("Executor did not finish before timeout", new Object[0]);
        }
        Object consumerResult = consumerFuture.get();
        this.handleResultOnFinish(consumerResult, operation, "Finished " + this.getOperationName());
        return (R)consumerResult;
    }

    public LogTarget getLogTarget() {
        if (((ExportOptions)this.options).getOutput() != null) {
            return LogTarget.SYSTEM_OUT;
        }
        return LogTarget.SYSTEM_ERR;
    }

    private List<SearchProducerWorker> createProducers(BlockingQueue<ObjectType> queue, OperationStatus operation) throws SchemaException, IOException {
        QueryFactory queryFactory = this.context.getPrismContext().queryFactory();
        ArrayList<SearchProducerWorker> producers = new ArrayList<SearchProducerWorker>();
        if (((ExportOptions)this.options).getOid() != null) {
            Set types = ((ExportOptions)this.options).getType();
            ObjectTypes type = types.isEmpty() ? ObjectTypes.OBJECT : (ObjectTypes)types.iterator().next();
            InOidFilter filter = queryFactory.createInOid(new String[]{((ExportOptions)this.options).getOid()});
            ObjectQuery query = queryFactory.createQuery((ObjectFilter)filter);
            producers.add(new SearchProducerWorker(this.context, (ExportOptions)this.options, queue, operation, producers, type, query));
            return producers;
        }
        List types = NinjaUtils.getTypes((Set)((ExportOptions)this.options).getType(), (Iterable)this.supportedObjectTypes());
        for (ObjectTypes type : types) {
            if (!this.context.getRepository().supports(type.getClassDefinition())) {
                this.log.warn("Repository doesn't support operation '{}' for objects of type '{}'", new Object[]{this.getOperationName(), type.getClassDefinition().getSimpleName()});
                continue;
            }
            ObjectFilter filter = NinjaUtils.createObjectFilter((FileReference)((ExportOptions)this.options).getFilter(), (NinjaContext)this.context, (Class)type.getClassDefinition());
            ObjectQuery query = queryFactory.createQuery(filter);
            if (ObjectTypes.SHADOW.equals((Object)type)) {
                List shadowProducers = this.createProducersForShadows(this.context, queue, operation, producers, filter);
                producers.addAll(shadowProducers);
                continue;
            }
            producers.add(new SearchProducerWorker(this.context, (ExportOptions)this.options, queue, operation, producers, type, query));
        }
        return producers;
    }

    protected Iterable<ObjectTypes> supportedObjectTypes() {
        return List.of(ObjectTypes.values());
    }

    private List<SearchProducerWorker> createProducersForShadows(NinjaContext context, BlockingQueue<ObjectType> queue, OperationStatus operation, List<SearchProducerWorker> producers, ObjectFilter filter) {
        QueryFactory queryFactory = context.getPrismContext().queryFactory();
        ArrayList<SearchProducerWorker> shadowProducers = new ArrayList<SearchProducerWorker>();
        try {
            RepositoryService repository = context.getRepository();
            Collection opts = SelectorOptions.createCollection((Object)GetOperationOptions.createRaw());
            OperationResult result = new OperationResult(OPERATION_LIST_RESOURCES);
            SearchResultList resultList = repository.searchObjects(ResourceType.class, queryFactory.createQuery((ObjectFilter)null), opts, result);
            List list = resultList.getList();
            if (list == null || list.isEmpty()) {
                shadowProducers.add(this.createShadowProducer(queue, operation, producers, filter));
                return shadowProducers;
            }
            ArrayList<RefFilter> existingResourceRefs = new ArrayList<RefFilter>();
            for (PrismObject obj : list) {
                RefFilter resourceRefFilter = this.createResourceRefFilter(obj.getOid());
                existingResourceRefs.add(resourceRefFilter);
                RefFilter fullFilter = resourceRefFilter;
                if (filter != null) {
                    fullFilter = queryFactory.createAnd(new ObjectFilter[]{fullFilter, filter});
                }
                shadowProducers.add(this.createShadowProducer(queue, operation, producers, (ObjectFilter)fullFilter));
            }
            ArrayList notFilters = new ArrayList();
            existingResourceRefs.forEach(f -> notFilters.add(queryFactory.createNot((ObjectFilter)f)));
            OrFilter fullFilter = queryFactory.createOr(new ObjectFilter[]{queryFactory.createAnd(notFilters), this.createResourceRefFilter(null)});
            if (filter != null) {
                fullFilter = queryFactory.createAnd(new ObjectFilter[]{fullFilter, filter});
            }
            shadowProducers.add(this.createShadowProducer(queue, operation, producers, (ObjectFilter)fullFilter));
        }
        catch (Exception ex) {
            shadowProducers.clear();
            shadowProducers.add(this.createShadowProducer(queue, operation, producers, filter));
        }
        return shadowProducers;
    }

    private RefFilter createResourceRefFilter(String oid) throws SchemaException {
        PrismContext prismContext = this.context.getPrismContext();
        ArrayList<PrismReferenceValue> values = new ArrayList<PrismReferenceValue>();
        if (oid != null) {
            values.add(prismContext.itemFactory().createReferenceValue(oid, ResourceType.COMPLEX_TYPE));
        }
        SchemaRegistry registry = prismContext.getSchemaRegistry();
        PrismReferenceDefinition def = (PrismReferenceDefinition)registry.findItemDefinitionByFullPath(ShadowType.class, PrismReferenceDefinition.class, new QName[]{ShadowType.F_RESOURCE_REF});
        return prismContext.queryFactory().createReferenceEqual((ItemPath)ShadowType.F_RESOURCE_REF, def, values);
    }

    private SearchProducerWorker createShadowProducer(BlockingQueue<ObjectType> queue, OperationStatus operation, List<SearchProducerWorker> producers, ObjectFilter filter) {
        ObjectQuery query = this.context.getPrismContext().queryFactory().createQuery(filter);
        query = this.context.getResourceSchemaRegistry().tryToNormalizeQuery(query);
        return new SearchProducerWorker(this.context, (ExportOptions)this.options, queue, operation, producers, ObjectTypes.SHADOW, query);
    }
}

