/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.launcher;

import java.nio.file.Path;
import org.springframework.boot.loader.launch.PropertiesLauncher;

public class MidPointLauncher {
    private MidPointLauncher() {
        throw new AssertionError((Object)"Non-instantiable launcher class");
    }

    public static void main(String[] args) throws Exception {
        String midpointHome = System.getProperty("midpoint.home");
        if (midpointHome == null && (midpointHome = System.getenv("MIDPOINT_HOME")) == null) {
            midpointHome = Path.of(System.getProperty("user.home"), "midpoint").toString();
        }
        midpointHome = Path.of(midpointHome, new String[0]).toAbsolutePath().toString();
        System.setProperty("midpoint.home", midpointHome);
        System.out.println("midPoint home: " + midpointHome);
        if (System.getProperty("loader.path") == null) {
            System.setProperty("loader.path", Path.of(midpointHome, "lib").toString());
        }
        System.out.println("Using loader path (for additional JARs): " + System.getProperty("loader.path"));
        PropertiesLauncher.main(args);
    }

    public static synchronized void stop(String[] args) {
        System.exit(0);
    }
}

