/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.impl;

import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.ninja.action.BaseOptions;
import com.evolveum.midpoint.ninja.action.ConnectionOptions;
import com.evolveum.midpoint.ninja.action.PolyStringNormalizerOptions;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.LogVerbosity;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.query.QueryConverter;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.SchemaService;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringNormalizerConfigurationType;
import java.io.Closeable;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;

public class NinjaContext
implements Closeable {
    private static final String REPOSITORY_SERVICE_BEAN = "repositoryService";
    private static final String AUDIT_SERVICE_BEAN = "auditService";
    private static final String CTX_NINJA = "classpath*:ctx-ninja.xml";
    public final PrintStream out;
    public final PrintStream err;
    private final List<Object> options;
    private final NinjaApplicationContextLevel applicationContextLevel;
    private Log log;
    private GenericXmlApplicationContext applicationContext;
    private MidpointConfiguration midpointConfiguration;
    private RepositoryService repository;
    private AuditService auditService;
    private PrismContext prismContext;
    private SchemaService schemaService;
    private final Map<String, String> systemPropertiesBackup = new HashMap();

    public NinjaContext(@NotNull PrintStream out, @NotNull PrintStream err, @NotNull List<Object> options, @NotNull NinjaApplicationContextLevel applicationContextLevel) {
        this.out = out;
        this.err = err;
        this.options = options;
        this.applicationContextLevel = applicationContextLevel;
    }

    @Override
    public void close() {
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
        this.systemPropertiesBackup.forEach((k, v) -> {
            if (v == null) {
                System.clearProperty(k);
            } else {
                System.setProperty(k, v);
            }
        });
    }

    public Log initializeLogging(LogTarget target) {
        LogVerbosity verbosity = this.getLogLevel();
        PrintStream stream = target == LogTarget.SYSTEM_OUT ? this.out : this.err;
        this.log = new Log(verbosity, stream);
        return this.log;
    }

    private LogVerbosity getLogLevel() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        if (base == null) {
            return LogVerbosity.DEFAULT;
        }
        if (base.isVerbose()) {
            return LogVerbosity.VERBOSE;
        }
        if (base.isSilent()) {
            return LogVerbosity.SILENT;
        }
        return LogVerbosity.DEFAULT;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private synchronized void setupRepositoryViaMidPointHome(ConnectionOptions options) {
        if (this.applicationContext != null) {
            return;
        }
        if (this.applicationContextLevel == NinjaApplicationContextLevel.NONE) {
            throw new IllegalStateException("Application context shouldn't be initialized");
        }
        this.log.info("Initializing using midpoint home ({})", new Object[]{this.applicationContextLevel});
        this.backupAndUpdateSystemProperty("midpoint.silent", "true");
        String midpointHome = options.getMidpointHome();
        this.backupAndUpdateSystemProperty("midpoint.home", midpointHome);
        this.overrideRepoConfiguration(options);
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext();
        ctx.load(new String[]{CTX_NINJA});
        ctx.load(this.applicationContextLevel.contexts);
        ctx.refresh();
        this.applicationContext = ctx;
        if (this.applicationContextLevel.containsPrismInitialization()) {
            this.updatePolyStringNormalizationConfiguration((PrismContext)ctx.getBean(PrismContext.class));
        }
    }

    private void backupAndUpdateSystemProperty(String key, String value) {
        String oldValue = System.getProperty(key);
        this.systemPropertiesBackup.put(key, oldValue);
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }

    private void overrideRepoConfiguration(ConnectionOptions options) {
        if (options.getUrl() != null) {
            this.backupAndUpdateSystemProperty("midpoint.repository.jdbcUrl", options.getUrl());
            this.backupAndUpdateSystemProperty("midpoint.repository.database", this.getDatabase(options.getUrl()));
        }
        if (options.getUsername() != null) {
            this.backupAndUpdateSystemProperty("midpoint.repository.jdbcUsername", options.getUsername());
        }
        if (options.getPassword() != null) {
            this.backupAndUpdateSystemProperty("midpoint.repository.jdbcPassword", options.getPassword());
        }
    }

    private String getDatabase(String url) {
        String postfix = url.replaceFirst("jdbc:", "").toLowerCase();
        if (postfix.startsWith("postgresql")) {
            return "postgresql";
        }
        if (postfix.startsWith("sqlserver")) {
            return "sqlserver";
        }
        if (postfix.startsWith("oracle")) {
            return "oracle";
        }
        if (postfix.startsWith("h2")) {
            return "h2";
        }
        throw new IllegalStateException("Unknown database for url " + url);
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext != null) {
            return this.applicationContext;
        }
        ConnectionOptions opts = (ConnectionOptions)this.getOptions(ConnectionOptions.class);
        if (opts == null) {
            throw new IllegalStateException("Couldn't setup application context, ConnectionOptions is not defined (null)");
        }
        this.setupRepositoryViaMidPointHome(opts);
        return this.applicationContext;
    }

    public <T> T getOptions(Class<T> type) {
        return (T)NinjaUtils.getOptions((List)this.options, type);
    }

    public List<Object> getAllOptions() {
        return this.options;
    }

    public MidpointConfiguration getMidpointConfiguration() {
        if (this.midpointConfiguration != null) {
            return this.midpointConfiguration;
        }
        this.midpointConfiguration = (MidpointConfiguration)this.getApplicationContext().getBean(MidpointConfiguration.class);
        return this.midpointConfiguration;
    }

    public RepositoryService getRepository() {
        if (this.repository != null) {
            return this.repository;
        }
        this.repository = (RepositoryService)this.getApplicationContext().getBean(REPOSITORY_SERVICE_BEAN, RepositoryService.class);
        return this.repository;
    }

    public AuditService getAuditService() {
        if (this.auditService != null) {
            return this.auditService;
        }
        this.auditService = (AuditService)this.getApplicationContext().getBean(AUDIT_SERVICE_BEAN, AuditService.class);
        return this.auditService;
    }

    public boolean isVerbose() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        return base.isVerbose();
    }

    public boolean isBatchMode() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        return base.isBatchMode();
    }

    public boolean isUserMode() {
        return !this.isBatchMode();
    }

    public Charset getCharset() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        String charset = base.getCharset();
        return Charset.forName(charset);
    }

    public PrismContext getPrismContext() {
        if (this.prismContext != null) {
            return this.prismContext;
        }
        this.prismContext = (PrismContext)this.getApplicationContext().getBean(PrismContext.class);
        return this.prismContext;
    }

    private void updatePolyStringNormalizationConfiguration(PrismContext ctx) {
        if (!this.shouldUseCustomPolyStringNormalizer()) {
            return;
        }
        try {
            PolyStringNormalizerConfigurationType psnConfiguration = this.createPolyStringNormalizerConfiguration();
            ctx.configurePolyStringNormalizer(psnConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Couldn't setup custom PolyString normalizer configuration", ex);
        }
    }

    private PolyStringNormalizerConfigurationType createPolyStringNormalizerConfiguration() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        PolyStringNormalizerOptions opts = base.getPolyStringNormalizerOptions();
        PolyStringNormalizerConfigurationType config = new PolyStringNormalizerConfigurationType();
        config.setClassName(opts.getPsnClassName());
        config.setTrim(opts.isPsnTrim());
        config.setNfkd(opts.isPsnNfkd());
        config.setTrimWhitespace(opts.isPsnTrimWhitespace());
        config.setLowercase(opts.isPsnLowercase());
        return config;
    }

    private boolean shouldUseCustomPolyStringNormalizer() {
        BaseOptions base = (BaseOptions)this.getOptions(BaseOptions.class);
        PolyStringNormalizerOptions opts = base.getPolyStringNormalizerOptions();
        return StringUtils.isNotEmpty((CharSequence)opts.getPsnClassName()) || opts.isPsnTrim() != null || opts.isPsnNfkd() != null || opts.isPsnTrimWhitespace() != null || opts.isPsnLowercase() != null;
    }

    public SchemaService getSchemaService() {
        if (this.schemaService != null) {
            return this.schemaService;
        }
        this.schemaService = (SchemaService)this.applicationContext.getBean(SchemaService.class);
        return this.schemaService;
    }

    public Log getLog() {
        return this.log;
    }

    public QueryConverter getQueryConverter() {
        return this.prismContext.getQueryConverter();
    }
}

