/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;

public class ExportConsumerWorker
extends AbstractWriterConsumerWorker<ExportOptions, ObjectType> {
    private PrismSerializer<String> serializer;

    public ExportConsumerWorker(NinjaContext context, ExportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
    }

    protected void init() {
        this.serializer = this.context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport().skipContainerIds(((ExportOptions)this.options).isSkipContainerIds()));
    }

    protected String getProlog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<c:objects xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:org=\"http://midpoint.evolveum.com/xml/ns/public/common/org-3\">\n";
    }

    protected void write(Writer writer, ObjectType object) throws SchemaException, IOException {
        String xml = (String)this.serializer.serialize((Item)object.asPrismObject());
        writer.write(xml);
    }

    protected String getEpilog() {
        return "</c:objects>\n";
    }
}

