/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.RunSqlAction;
import com.evolveum.midpoint.ninja.action.RunSqlOptions;
import com.evolveum.midpoint.ninja.action.UpgradeBaseAction;
import com.evolveum.midpoint.ninja.action.VerifyAction;
import com.evolveum.midpoint.ninja.action.VerifyOptions;
import com.evolveum.midpoint.ninja.action.VerifyResult;
import com.evolveum.midpoint.ninja.action.upgrade.action.DownloadDistributionAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.DownloadDistributionOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.DownloadDistributionResult;
import com.evolveum.midpoint.ninja.action.upgrade.action.PreUpgradeCheckAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.PreUpgradeCheckOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeDistributionOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeInstallationAction;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeInstallationOptions;
import java.io.File;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;

public class UpgradeDistributionAction
extends UpgradeBaseAction<UpgradeDistributionOptions, ActionResult<Void>> {
    public String getOperationName() {
        return "upgrade distribution";
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResult<Void> execute() throws Exception {
        File tempDirectory = this.createTmpDirectory(((UpgradeDistributionOptions)this.options).getTempDirectory());
        if (!((UpgradeDistributionOptions)this.options).isSkipPreCheck()) {
            PreUpgradeCheckOptions preUpgradeCheckOptions = new PreUpgradeCheckOptions();
            ActionResult shouldContinue = (ActionResult)this.executeAction((Action)new PreUpgradeCheckAction(), (Object)preUpgradeCheckOptions);
            if (!((Boolean)shouldContinue.result()).booleanValue()) {
                this.log.error(Ansi.ansi().fgRed().a("Pre-upgrade check failed.").reset().toString(), new Object[0]);
                return new ActionResult(null, shouldContinue.exitCode());
            }
            this.log.info(Ansi.ansi().fgGreen().a("Pre-upgrade check succeeded.").reset().toString(), new Object[0]);
        } else {
            this.log.warn("Pre-upgrade checks skipped.", new Object[0]);
        }
        if (!((UpgradeDistributionOptions)this.options).isSkipVerification()) {
            VerifyOptions verifyOptions = new VerifyOptions();
            verifyOptions.setMultiThread(((UpgradeDistributionOptions)this.options).getVerificationThreads());
            verifyOptions.setStopOnCriticalError(((UpgradeDistributionOptions)this.options).isStopOnCriticalError());
            VerifyResult verifyResult = (VerifyResult)this.executeAction((Action)new VerifyAction(true), (Object)verifyOptions);
            if (verifyResult.hasCriticalItems()) {
                this.log.error(Ansi.ansi().fgRed().a("Pre-upgrade verification failed with {} critical items.").reset().toString(), new Object[]{verifyResult.getCriticalCount()});
                this.log.error("To get rid of critical items, please run 'verify' command, review the results and then run 'upgrade-objects' before upgrading the distribution.\n", new Object[0]);
                this.log.error("Example commands:", new Object[0]);
                this.log.error("To verify all objects and save report to CSV file:", new Object[0]);
                this.log.error("ninja.sh verify --report-style csv --output verify-output.csv", new Object[0]);
                this.log.error("To update all objects", new Object[0]);
                this.log.error("ninja.sh upgrade-objects --verification-file verify-output.csv", new Object[0]);
                return null;
            }
            this.log.info(Ansi.ansi().fgGreen().a("Pre-upgrade verification succeeded.").reset().toString(), new Object[0]);
        } else {
            this.log.warn("Verification skipped.", new Object[0]);
        }
        DownloadDistributionOptions downloadOpts = new DownloadDistributionOptions();
        downloadOpts.setTempDirectory(tempDirectory);
        downloadOpts.setDistributionArchive(((UpgradeDistributionOptions)this.options).getDistributionArchive());
        downloadOpts.setDistributionVersion(((UpgradeDistributionOptions)this.options).getDistributionVersion());
        DownloadDistributionResult downloadResult = (DownloadDistributionResult)this.executeAction((Action)new DownloadDistributionAction(), (Object)downloadOpts);
        File distributionDirectory = downloadResult.getDistributionDirectory();
        this.log.info("Starting repository database structure upgrade", new Object[0]);
        this.runUpgradeSql(RunSqlOptions.Mode.REPOSITORY, distributionDirectory);
        this.log.info("Starting audit database structure upgrade", new Object[0]);
        this.runUpgradeSql(RunSqlOptions.Mode.AUDIT, distributionDirectory);
        UpgradeInstallationOptions installationOpts = new UpgradeInstallationOptions();
        installationOpts.setDistributionDirectory(downloadResult.getDistributionDirectory());
        installationOpts.setBackup(((UpgradeDistributionOptions)this.options).isBackupMidpointDirectory());
        installationOpts.setInstallationDirectory(((UpgradeDistributionOptions)this.options).getInstallationDirectory());
        this.executeAction((Action)new UpgradeInstallationAction(), (Object)installationOpts);
        return null;
    }

    private void runUpgradeSql(RunSqlOptions.Mode mode, File distributionDirectory) throws Exception {
        RunSqlOptions runSqlOptions = new RunSqlOptions();
        runSqlOptions.setUpgrade(true);
        runSqlOptions.setMode(mode);
        runSqlOptions.setScripts(mode.updateScripts.stream().map(f -> new File(distributionDirectory, f.getPath())).collect(Collectors.toList()));
        this.executeAction((Action)new RunSqlAction(), (Object)runSqlOptions);
    }
}

