/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade;

import com.evolveum.midpoint.ninja.action.upgrade.SkipUpgradeItem;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectHandler;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectResult;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectsConsumerWorker;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectsItemsSummary;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeObjectsOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.repo.api.RepoModifyOptions;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class UpgradeObjectsConsumerWorker<T extends ObjectType>
extends BaseWorker<UpgradeObjectsOptions, T> {
    private final Map<UUID, Set<SkipUpgradeItem>> skipUpgradeForOids;
    private final Log log;
    private UpgradeObjectsItemsSummary itemsSummary = new UpgradeObjectsItemsSummary();

    public UpgradeObjectsConsumerWorker(Map<UUID, Set<SkipUpgradeItem>> skipUpgradeForOids, NinjaContext context, UpgradeObjectsOptions options, BlockingQueue<T> queue, OperationStatus operation) {
        super(context, (Object)options, queue, operation);
        this.skipUpgradeForOids = skipUpgradeForOids;
        this.log = context.getLog();
    }

    public UpgradeObjectsItemsSummary getItemsSummary() {
        return this.itemsSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            RepositoryService repository = this.context.getRepository();
            block7: while (true) {
                try {
                    while (!this.shouldConsumerStop()) {
                        ObjectType object = null;
                        try {
                            object = (ObjectType)this.queue.poll(2L, TimeUnit.SECONDS);
                            if (object == null) continue;
                            this.processObject(repository, object);
                            this.operation.incrementTotal();
                            continue block7;
                        }
                        catch (Exception ex) {
                            this.log.error("Couldn't store object {}, reason: {}", ex, new Object[]{object, ex.getMessage()});
                            this.operation.incrementError();
                        }
                    }
                    break block10;
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), ex, new Object[0]);
                    break block10;
                }
            }
            finally {
                this.markDone();
                if (this.isWorkersDone()) {
                    this.operation.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processObject(RepositoryService repository, T object) throws Exception {
        PrismObject prismObject = object.asPrismObject();
        PrismObject cloned = prismObject.clone();
        UpgradeObjectHandler executor = new UpgradeObjectHandler((UpgradeObjectsOptions)this.options, this.context, this.skipUpgradeForOids, this.itemsSummary);
        UpgradeObjectResult result = executor.execute(cloned);
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$upgrade$UpgradeObjectResult[result.ordinal()]) {
            case 1: {
                this.operation.incrementSkipped();
            }
            case 2: {
                return;
            }
        }
        OperationResult opResult = new OperationResult("Modify object");
        try {
            ObjectDelta delta = prismObject.diff(cloned);
            Collection modifications = delta.getModifications();
            RepoModifyOptions opts = modifications.isEmpty() ? RepoModifyOptions.createForceReindex() : new RepoModifyOptions();
            repository.modifyObject(object.getClass(), object.getOid(), delta.getModifications(), opts, opResult);
        }
        catch (Exception ex) {
            try {
                this.log.error("Couldn't modify object {} ({})", ex, new Object[]{object.getName(), object.getOid()});
            }
            catch (Throwable throwable) {
                opResult.computeStatusIfUnknown();
                if (!opResult.isSuccess()) {
                    this.log.error("Modification of '{} ({})' didn't finished with success\n{}", new Object[]{object.getName(), object.getOid(), opResult.debugDumpLazily()});
                }
                throw throwable;
            }
            opResult.computeStatusIfUnknown();
            if (!opResult.isSuccess()) {
                this.log.error("Modification of '{} ({})' didn't finished with success\n{}", new Object[]{object.getName(), object.getOid(), opResult.debugDumpLazily()});
            }
        }
        opResult.computeStatusIfUnknown();
        if (!opResult.isSuccess()) {
            this.log.error("Modification of '{} ({})' didn't finished with success\n{}", new Object[]{object.getName(), object.getOid(), opResult.debugDumpLazily()});
        }
    }
}

