/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade;

import com.evolveum.midpoint.ninja.action.upgrade.ProgressListener;
import com.evolveum.midpoint.ninja.action.upgrade.ProgressResponseBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class DistributionManager {
    private static final String DOWNLOAD_URL = "https://download.evolveum.com/midpoint/";
    public static final String LATEST_VERSION = "latest";
    private File tempDirectory;

    public DistributionManager(@NotNull File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public File downloadDistribution(@NotNull String version, ProgressListener listener) throws IOException {
        String distributionFile = this.createFileName(version);
        File file = new File(this.tempDirectory, System.currentTimeMillis() + "-" + distributionFile);
        FileUtils.forceMkdirParent((File)file);
        file.createNewFile();
        String url = DOWNLOAD_URL + version + "/" + distributionFile;
        Request request = new Request.Builder().url(url).build();
        OkHttpClient client = new OkHttpClient.Builder().addNetworkInterceptor(chain -> {
            Response originalResponse = chain.proceed(chain.request());
            return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), listener)).build();
        }).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Couldn't download distribution with version " + version + ". Unexpected code " + response.code() + ", message: " + response.message() + " for url " + url);
            }
            try (InputStream is = response.body().byteStream();){
                FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
            }
        }
        return file;
    }

    private String createFileName(String versionNumber) {
        return "midpoint-" + versionNumber + "-dist.zip";
    }
}

