/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining;

import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.mining.ExportMiningConsumerWorker;
import com.evolveum.midpoint.ninja.action.mining.ExportMiningOptions;
import com.evolveum.midpoint.ninja.action.mining.ExportMiningProducerWorker;
import com.evolveum.midpoint.ninja.action.worker.ProgressReporterWorker;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.prism.query.QueryFactory;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.FocusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ExportMiningRepositoryAction
extends RepositoryAction<ExportMiningOptions, Void> {
    private static final int QUEUE_CAPACITY_PER_THREAD = 100;
    private static final long CONSUMERS_WAIT_FOR_START = 2000L;
    public static final String OPERATION_SHORT_NAME = "exportMining";
    public static final String OPERATION_NAME = ExportMiningRepositoryAction.class.getName() + ".exportMining";

    public String getOperationName() {
        return "export mining data";
    }

    protected Runnable createConsumer(BlockingQueue<FocusType> queue, OperationStatus operation) {
        return new ExportMiningConsumerWorker(this.context, (ExportMiningOptions)this.options, queue, operation);
    }

    public Void execute() throws Exception {
        OperationResult result = new OperationResult(OPERATION_NAME);
        OperationStatus operation = new OperationStatus(this.context, result);
        ExecutorService executor = Executors.newFixedThreadPool(((ExportMiningOptions)this.options).getMultiThread() + 2);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(100 * ((ExportMiningOptions)this.options).getMultiThread());
        List producers = this.createProducers(queue, operation);
        this.log.info("Starting exportMining", new Object[0]);
        operation.start();
        for (int i = 0; i < producers.size() && i < ((ExportMiningOptions)this.options).getMultiThread(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        Thread.sleep(2000L);
        executor.execute((Runnable)new ProgressReporterWorker(this.context, this.options, queue, operation));
        Runnable consumer = this.createConsumer(queue, operation);
        executor.execute(consumer);
        for (int i = ((ExportMiningOptions)this.options).getMultiThread(); i < producers.size(); ++i) {
            executor.execute((Runnable)producers.get(i));
        }
        executor.shutdown();
        boolean awaitResult = executor.awaitTermination(365L, TimeUnit.DAYS);
        if (!awaitResult) {
            this.log.error("Executor did not finish before timeout", new Object[0]);
        }
        this.handleResultOnFinish(null, operation, "Finished exportMining");
        return null;
    }

    public LogTarget getLogTarget() {
        if (((ExportMiningOptions)this.options).getOutput() != null) {
            return LogTarget.SYSTEM_OUT;
        }
        return LogTarget.SYSTEM_ERR;
    }

    @NotNull
    private List<ExportMiningProducerWorker> createProducers(BlockingQueue<FocusType> queue, OperationStatus operation) throws SchemaException, IOException {
        QueryFactory queryFactory = this.context.getPrismContext().queryFactory();
        ArrayList<ExportMiningProducerWorker> producers = new ArrayList<ExportMiningProducerWorker>();
        ObjectFilter filter = NinjaUtils.createObjectFilter((FileReference)((ExportMiningOptions)this.options).getRoleFilter(), (NinjaContext)this.context, RoleType.class);
        ObjectQuery query = queryFactory.createQuery(filter);
        producers.add(new ExportMiningProducerWorker(this.context, (ExportMiningOptions)this.options, queue, operation, producers, query, RoleType.class));
        filter = NinjaUtils.createObjectFilter((FileReference)((ExportMiningOptions)this.options).getUserFilter(), (NinjaContext)this.context, UserType.class);
        query = queryFactory.createQuery(filter);
        producers.add(new ExportMiningProducerWorker(this.context, (ExportMiningOptions)this.options, queue, operation, producers, query, UserType.class));
        if (((ExportMiningOptions)this.options).isIncludeOrg()) {
            filter = NinjaUtils.createObjectFilter((FileReference)((ExportMiningOptions)this.options).getOrgFilter(), (NinjaContext)this.context, OrgType.class);
            query = queryFactory.createQuery(filter);
            producers.add(new ExportMiningProducerWorker(this.context, (ExportMiningOptions)this.options, queue, operation, producers, query, OrgType.class));
        }
        return producers;
    }
}

