/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining;

import com.evolveum.midpoint.ninja.action.mining.ExportMiningOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.schema.GetOperationOptionsBuilder;
import com.evolveum.midpoint.schema.ResultHandler;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.FocusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;

public class ExportMiningProducerWorker
extends BaseWorker<ExportMiningOptions, FocusType> {
    private final ObjectQuery query;
    private final Class<?> type;

    public ExportMiningProducerWorker(NinjaContext context, ExportMiningOptions options, BlockingQueue<FocusType> queue, OperationStatus operation, List<ExportMiningProducerWorker> producers, ObjectQuery query, Class<?> type) {
        super(context, (Object)options, queue, operation, producers);
        this.query = query;
        this.type = type;
    }

    public void run() {
        Log log = this.context.getLog();
        try {
            GetOperationOptionsBuilder optionsBuilder = this.context.getSchemaService().getOperationOptionsBuilder();
            if (this.type.equals(RoleType.class)) {
                optionsBuilder = NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, RoleType.class);
                this.context.getRepository().searchObjectsIterative(RoleType.class, this.query, this.getRoleTypeResultHandler(log), optionsBuilder.build(), true, this.operation.getResult());
            } else if (this.type.equals(UserType.class)) {
                optionsBuilder = NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, UserType.class);
                this.context.getRepository().searchObjectsIterative(UserType.class, this.query, this.getUserTypeResultHandler(log), optionsBuilder.build(), true, this.operation.getResult());
            } else if (this.type.equals(OrgType.class)) {
                optionsBuilder = NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, OrgType.class);
                this.context.getRepository().searchObjectsIterative(OrgType.class, this.query, this.getOrgTypeResultHandler(log), optionsBuilder.build(), true, this.operation.getResult());
            }
        }
        catch (NinjaException ex) {
            log.error(ex.getMessage(), (Exception)((Object)ex), new Object[0]);
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.markDone();
            if (this.isWorkersDone() && !this.operation.isFinished()) {
                this.operation.producerFinish();
            }
        }
    }

    @NotNull
    private ResultHandler<OrgType> getOrgTypeResultHandler(Log log) {
        return (object, parentResult) -> {
            try {
                this.queue.put((FocusType)object.asObjectable());
            }
            catch (InterruptedException ex) {
                log.error("Couldn't queue orgType object {}, reason: {}", (Exception)ex, new Object[]{object, ex.getMessage()});
            }
            return true;
        };
    }

    @NotNull
    private ResultHandler<UserType> getUserTypeResultHandler(Log log) {
        return (object, parentResult) -> {
            try {
                this.queue.put((FocusType)object.asObjectable());
            }
            catch (InterruptedException ex) {
                log.error("Couldn't queue userType object {}, reason: {}", (Exception)ex, new Object[]{object, ex.getMessage()});
            }
            return true;
        };
    }

    @NotNull
    private ResultHandler<RoleType> getRoleTypeResultHandler(Log log) {
        return (object, parentResult) -> {
            try {
                this.queue.put((FocusType)object.asObjectable());
            }
            catch (InterruptedException ex) {
                log.error("Couldn't queue roleType object {}, reason: {}", (Exception)ex, new Object[]{object, ex.getMessage()});
            }
            return true;
        };
    }
}

