/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.ninja.action.audit.ImportAuditOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.crypto.Protector;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ExceptionUtil;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;

public class ImportAuditConsumerWorker
extends BaseWorker<ImportAuditOptions, AuditEventRecordType> {
    public ImportAuditConsumerWorker(NinjaContext context, ImportAuditOptions options, BlockingQueue<AuditEventRecordType> queue, OperationStatus operation, List<ImportAuditConsumerWorker> consumers) {
        super(context, (Object)options, queue, operation, consumers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: {
            ApplicationContext ctx = this.context.getApplicationContext();
            Protector protector = (Protector)ctx.getBean(Protector.class);
            block5: while (true) {
                while (!this.shouldConsumerStop()) {
                    AuditEventRecordType auditRecord = null;
                    try {
                        auditRecord = (AuditEventRecordType)this.queue.poll(2L, TimeUnit.SECONDS);
                        if (auditRecord == null) continue;
                        AuditService auditService = this.context.getAuditService();
                        auditService.audit(auditRecord, new OperationResult("Import audit"));
                        this.operation.incrementTotal();
                        continue block5;
                    }
                    catch (Exception ex) {
                        Throwable cause = ExceptionUtil.findRootCause((Throwable)ex);
                        if (cause.toString().contains("duplicate key value violates unique constraint \"ma_audit_event_") && cause.toString().contains("Detail: Key (id, \"timestamp\")")) {
                            this.context.getLog().info("Audit already exists, skipping ({}, {})", new Object[]{auditRecord.getRepoId(), auditRecord.getTimestamp()});
                            this.operation.incrementSkipped();
                            continue;
                        }
                        this.context.getLog().error("Couldn't add object {}, reason: {}", ex, new Object[]{auditRecord, ex.getMessage()});
                        this.operation.incrementError();
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.markDone();
                if (this.isWorkersDone()) {
                    this.operation.finish();
                }
            }
        }
    }
}

