/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.audit.ExportAuditOptions;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;

public class ExportAuditConsumerWorker
extends AbstractWriterConsumerWorker<ExportAuditOptions, AuditEventRecordType> {
    private PrismSerializer<String> serializer;

    public ExportAuditConsumerWorker(NinjaContext context, ExportAuditOptions options, BlockingQueue<AuditEventRecordType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
    }

    protected void init() {
        this.serializer = this.context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport().serializeReferenceNames(true).skipContainerIds(true));
    }

    protected String getProlog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<c:objects xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:org=\"http://midpoint.evolveum.com/xml/ns/public/common/org-3\">\n";
    }

    protected void write(Writer writer, AuditEventRecordType object) throws SchemaException, IOException {
        String xml = (String)this.serializer.serialize((PrismValue)object.asPrismContainerValue());
        writer.write(xml);
    }

    protected String getEpilog() {
        return "</c:objects>\n";
    }
}

