/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.DeleteOptions;
import com.evolveum.midpoint.ninja.action.DeleteRepositoryAction;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.GetOperationOptions;
import com.evolveum.midpoint.schema.ResultHandler;
import com.evolveum.midpoint.schema.SelectorOptions;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class DeleteRepositoryAction
extends RepositoryAction<DeleteOptions, Void> {
    private static final String DOT_CLASS = DeleteRepositoryAction.class.getName() + ".";
    private static final String OPERATION_DELETE = DOT_CLASS + "delete";

    public String getOperationName() {
        return "delete objects";
    }

    public Void execute() throws Exception {
        String oid = ((DeleteOptions)this.options).getOid();
        if (oid != null) {
            this.deleteByOid();
            return null;
        }
        ObjectTypes type = ((DeleteOptions)this.options).getType();
        if (type == null) {
            type = ObjectTypes.OBJECT;
        }
        ObjectQuery query = NinjaUtils.createObjectQuery((FileReference)((DeleteOptions)this.options).getFilter(), (NinjaContext)this.context, (Class)type.getClassDefinition());
        this.deleteByFilter(query);
        return null;
    }

    private void deleteByOid() throws SchemaException {
        ObjectQuery query = this.context.getPrismContext().queryFor(ObjectType.class).id(new String[]{((DeleteOptions)this.options).getOid()}).build();
        this.deleteByFilter(query);
    }

    private void deleteByFilter(ObjectQuery query) throws SchemaException {
        OperationResult result = new OperationResult(OPERATION_DELETE);
        OperationStatus operation = new OperationStatus(this.context, result);
        operation.start();
        this.log.info("Starting delete", new Object[0]);
        ObjectTypes type = ((DeleteOptions)this.options).getType();
        if (type != null) {
            this.deleteByFilter(type, query, operation, result);
        } else {
            for (ObjectTypes t : ObjectTypes.values()) {
                if (Modifier.isAbstract(t.getClassDefinition().getModifiers())) continue;
                this.deleteByFilter(t, query, operation, result);
            }
        }
        operation.finish();
        this.handleResultOnFinish(null, operation, "Delete finished");
    }

    private void deleteByFilter(ObjectTypes type, ObjectQuery query, OperationStatus operation, OperationResult result) throws SchemaException {
        ResultHandler handler = (prismObject, operationResult) -> {
            try {
                State state = ((DeleteOptions)this.options).isAsk() ? this.askForState(prismObject) : State.DELETE;
                switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$DeleteRepositoryAction$State[state.ordinal()]) {
                    case 1: {
                        operation.incrementSkipped();
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
                RepositoryService repository = this.context.getRepository();
                repository.deleteObject(prismObject.getCompileTimeClass(), prismObject.getOid(), operationResult);
                operation.incrementTotal();
            }
            catch (ObjectNotFoundException state) {
            }
            catch (IOException ex) {
                this.context.getLog().error("Couldn't delete object {}, reason: {}", (Exception)ex, new Object[]{prismObject, ex.getMessage()});
                operation.incrementError();
            }
            return true;
        };
        ArrayList<SelectorOptions> opts = new ArrayList<SelectorOptions>();
        if (((DeleteOptions)this.options).isRaw()) {
            opts.add(new SelectorOptions((Object)GetOperationOptions.createRaw()));
        }
        RepositoryService repository = this.context.getRepository();
        repository.searchObjectsIterative(type.getClassDefinition(), query, handler, opts, true, result);
    }

    private State askForState(PrismObject<?> object) throws IOException {
        this.log.info("Do you really want to delete object '" + object.toDebugName() + "'? Yes/No/Cancel", new Object[0]);
        State state = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in));){
            while (state == null) {
                String strState = br.readLine();
                if (StringUtils.isEmpty((CharSequence)strState)) continue;
                if ("y".equalsIgnoreCase(strState = strState.toLowerCase()) || "yes".equalsIgnoreCase(strState)) {
                    state = State.DELETE;
                }
                if ("n".equalsIgnoreCase(strState) || "no".equalsIgnoreCase(strState)) {
                    state = State.SKIP;
                }
                if (!"c".equalsIgnoreCase(strState) && !"cancel".equalsIgnoreCase(strState)) continue;
                state = State.STOP;
            }
        }
        return state;
    }
}

