/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.schema.result.OperationResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Action<O, R> {
    protected final boolean partial;
    protected Log log;
    protected NinjaContext context;
    protected O options;

    public Action() {
        this(false);
    }

    public Action(boolean partial) {
        this.partial = partial;
    }

    public void init(NinjaContext context, O options) {
        this.context = context;
        this.options = options;
        this.log = context.initializeLogging(this.getLogTarget());
    }

    public void destroy() {
    }

    public LogTarget getLogTarget() {
        return LogTarget.SYSTEM_OUT;
    }

    protected void handleResultOnFinish(R consumerResult, OperationStatus operation, String finishMessage) {
        OperationResult result = operation.getResult();
        result.recomputeStatus();
        if (result.isAcceptable()) {
            this.log.info("{} in {}s. {}", new Object[]{finishMessage, NinjaUtils.DECIMAL_FORMAT.format(operation.getTotalTime()), operation.print()});
        } else {
            this.log.error("{} in {}s with some problems, reason: {}. {}", new Object[]{finishMessage, NinjaUtils.DECIMAL_FORMAT.format(operation.getTotalTime()), result.getMessage(), operation.print()});
            if (this.context.isVerbose()) {
                this.log.error("Full result\n{}", new Object[]{result.debugDumpLazily()});
            }
        }
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        return NinjaApplicationContextLevel.FULL_REPOSITORY;
    }

    public abstract String getOperationName();

    public abstract R execute() throws Exception;
}

