/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.evolveum.midpoint.ninja.MainResult;
import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.BaseOptions;
import com.evolveum.midpoint.ninja.action.ConnectionOptions;
import com.evolveum.midpoint.ninja.impl.Command;
import com.evolveum.midpoint.ninja.impl.LogLevel;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.InputParameterException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.util.exception.SystemException;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;

public class Main {
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public static void main(String[] args) {
        MainResult result = new Main().run(args);
        int exitCode = result.exitCode();
        if (exitCode != 0) {
            String exitMessage = result.exitMessage();
            if (exitMessage != null) {
                System.err.println(exitMessage);
            }
            System.exit(exitCode);
        }
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(@NotNull PrintStream out) {
        this.out = out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public void setErr(@NotNull PrintStream err) {
        this.err = err;
    }

    @NotNull
    protected MainResult<?> run(String[] args) {
        AnsiConsole.systemInstall();
        try {
            MainResult mainResult = this.runInternal(args);
            return mainResult;
        }
        finally {
            this.out.flush();
            this.err.flush();
            AnsiConsole.systemUninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private <T> MainResult<?> runInternal(String[] args) {
        Object result;
        Action action;
        NinjaContext context;
        BaseOptions base;
        block22: {
            NinjaApplicationContextLevel contextLevel;
            JCommander jc = NinjaUtils.setupCommandLineParser();
            try {
                jc.parse(args);
            }
            catch (ParameterException ex) {
                this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)ex.getMessage()));
                String parsedCommand = ex.getJCommander().getParsedCommand();
                BaseOptions base2 = (BaseOptions)NinjaUtils.getOptions((List)jc.getObjects(), BaseOptions.class);
                if (base2 != null && base2.isVerbose()) {
                    this.printHelp(jc, parsedCommand);
                }
                return MainResult.EMPTY_ERROR;
            }
            String parsedCommand = jc.getParsedCommand();
            base = Objects.requireNonNull((BaseOptions)NinjaUtils.getOptions((List)jc.getObjects(), BaseOptions.class));
            ConsoleFormat.setBatchMode((boolean)base.isBatchMode());
            if (base.isVerbose() && base.isSilent()) {
                this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)"Can't use -v and -s together (verbose and silent)"));
                this.printHelp(jc, parsedCommand);
                return MainResult.EMPTY_ERROR;
            }
            if (BooleanUtils.isTrue((Boolean)base.isVersion())) {
                this.printVersion(base.isVerbose());
                return MainResult.EMPTY_SUCCESS;
            }
            if (base.isHelp() || parsedCommand == null) {
                this.printHelp(jc, parsedCommand);
                return MainResult.EMPTY_SUCCESS;
            }
            context = null;
            action = Command.createAction((String)parsedCommand);
            if (action == null) {
                this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)("Action for command '" + parsedCommand + "' not found")));
                MainResult mainResult = MainResult.EMPTY_ERROR;
                return mainResult;
            }
            Object options = ((JCommander)jc.getCommands().get(parsedCommand)).getObjects().get(0);
            ArrayList allOptions = new ArrayList(jc.getObjects());
            allOptions.add(options);
            context = new NinjaContext(this.out, this.err, allOptions, action.getApplicationContextLevel(allOptions));
            action.init(context, options);
            String startMessage = ConsoleFormat.formatActionStartMessage((Action)action);
            if (startMessage != null) {
                context.getLog().info("", new Object[0]);
                context.getLog().info(startMessage, new Object[0]);
                context.getLog().info("", new Object[0]);
            }
            if ((contextLevel = action.getApplicationContextLevel(allOptions)) != NinjaApplicationContextLevel.NONE) {
                ConnectionOptions connectionOptions = Objects.requireNonNullElse((ConnectionOptions)context.getOptions(ConnectionOptions.class), new ConnectionOptions());
                this.checkAndWarnMidpointHome(connectionOptions.getMidpointHome());
            }
            if (!((result = action.execute()) instanceof ActionResult)) break block22;
            ActionResult actionResult = (ActionResult)result;
            MainResult mainResult = new MainResult(actionResult.result(), actionResult.exitCode(), actionResult.exitMessage());
            action.destroy();
            this.cleanupResources(base, context);
            return mainResult;
        }
        MainResult mainResult = new MainResult(result);
        action.destroy();
        this.cleanupResources(base, context);
        return mainResult;
        {
            catch (Throwable throwable) {
                try {
                    action.destroy();
                    throw throwable;
                }
                catch (InputParameterException ex) {
                    this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)ex.getMessage()));
                    int exitCode = ex.getExitCode() != null ? ex.getExitCode() : 1;
                    MainResult mainResult2 = new MainResult((Object)ex.getMessage(), exitCode);
                    return mainResult2;
                }
                catch (Exception ex) {
                    this.handleException(base, ex);
                    MainResult mainResult3 = MainResult.EMPTY_ERROR;
                    return mainResult3;
                }
            }
        }
        finally {
            this.cleanupResources(base, context);
        }
    }

    private void checkAndWarnMidpointHome(String midpointHome) {
        File config;
        if (StringUtils.isEmpty((CharSequence)midpointHome)) {
            throw new InputParameterException("Midpoint home -m option expected, but not defined");
        }
        File file = new File(midpointHome);
        if (!file.exists() || !file.isDirectory()) {
            throw new InputParameterException("Midpoint home directory '" + midpointHome + "' doesn't exist or is not a directory");
        }
        String configFile = "config.xml";
        if (System.getProperty("midpoint.configFile") != null) {
            configFile = System.getProperty("midpoint.configFile");
        }
        if (!(config = new File(file, configFile)).exists() || config.isDirectory()) {
            throw new InputParameterException("Midpoint home config xml file '" + config.getAbsolutePath() + "' doesn't exist");
        }
    }

    private void cleanupResources(BaseOptions opts, NinjaContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (Exception ex) {
            this.printException("Unexpected exception occurred (" + ex.getClass() + ") during destroying context", ex, opts.isVerbose());
        }
    }

    private Exception checkAndUnwrapException(Exception ex) {
        Throwable throwable = ex;
        while (throwable != null && !Objects.equals(throwable.getCause(), throwable) && !((throwable = throwable.getCause()) instanceof SystemException)) {
        }
        if (throwable instanceof SystemException && throwable.getMessage().contains("repository context")) {
            ex = throwable;
        }
        return ex;
    }

    private void handleException(BaseOptions opts, Exception ex) {
        if (!opts.isSilent()) {
            ex = this.checkAndUnwrapException(ex);
            this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)("Unexpected exception occurred (" + ex.getClass() + "), reason: " + ex.getMessage())));
        }
        if (opts.isVerbose()) {
            String stack = NinjaUtils.printStackToString((Exception)ex);
            this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.DEBUG, (String)("Exception stack trace:\n" + stack)));
        }
    }

    private void printVersion(boolean verbose) {
        URL url = Main.class.getResource("/version");
        if (url == null) {
            this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)"Couldn't obtain version. Version file not available."));
            return;
        }
        try (InputStream is = url.openStream();){
            String version = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8).trim();
            this.out.println(version);
        }
        catch (Exception ex) {
            this.printException("Couldn't obtain version", ex, verbose);
        }
    }

    private void printException(String message, Exception ex, boolean verbose) {
        Object msg = StringUtils.isNotEmpty((CharSequence)message) ? message + ", reason: " : "";
        msg = (String)msg + ex.getMessage();
        this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.ERROR, (String)msg));
        if (verbose) {
            String stack = NinjaUtils.printStackToString((Exception)ex);
            this.err.println(ConsoleFormat.formatLogMessage((LogLevel)LogLevel.DEBUG, (String)("Exception stack trace:\n" + stack)));
        }
    }

    private void printHelp(JCommander jc, String parsedCommand) {
        String help = NinjaUtils.createHelp((JCommander)jc, (String)parsedCommand);
        this.out.println(help);
    }
}

