/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.VerifyOptions;
import com.evolveum.midpoint.ninja.action.VerifyResult;
import com.evolveum.midpoint.ninja.action.verify.VerificationReporter;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.schema.validator.UpgradeValidationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;

public class VerifyConsumerWorker
extends AbstractWriterConsumerWorker<VerifyOptions, ObjectType> {
    private final Log log;
    private VerificationReporter reporter;

    public VerifyConsumerWorker(NinjaContext context, VerifyOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
        this.log = context.getLog();
    }

    protected void init() {
        this.reporter = new VerificationReporter((VerifyOptions)this.options, this.context.getPrismContext(), this.context.getCharset(), this.log);
        this.reporter.setCreateDeltaFile(true);
        this.reporter.init();
    }

    public void destroy() {
        this.reporter.destroy();
    }

    protected String getProlog() {
        return this.reporter.getProlog();
    }

    protected String getEpilog() {
        return this.reporter.getEpilog();
    }

    protected void write(Writer writer, ObjectType object) throws IOException {
        PrismObject prismObject = object.asPrismObject();
        try {
            PrismObject cloned = prismObject.clone();
            UpgradeValidationResult result = this.reporter.verify(writer, cloned);
            if (((VerifyOptions)this.options).isStopOnCriticalError() && result.hasCritical()) {
                this.shouldConsumerStop();
            }
        }
        catch (Exception ex) {
            this.log.error("Couldn't verify object {} ({})", ex, new Object[]{object.getName(), object.getOid()});
        }
    }

    public VerifyResult getResult() {
        return this.reporter.getResult();
    }
}

