/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.common.validator.EventHandler;
import com.evolveum.midpoint.common.validator.LegacyValidator;
import com.evolveum.midpoint.ninja.action.BasicImportOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.action.worker.ImportProducerWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.match.MatchingRuleRegistry;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.springframework.context.ApplicationContext;

public class ImportProducerWorker<T extends Containerable>
extends BaseWorker<BasicImportOptions, T> {
    private final ObjectFilter filter;
    private final boolean stopAfterFound;
    private final boolean continueOnInputError;
    private String currentOid = null;
    private boolean convertMissingType = false;
    private boolean compatMode = false;

    public ImportProducerWorker(NinjaContext context, BasicImportOptions options, BlockingQueue<T> queue, OperationStatus operation, ObjectFilter filter, boolean stopAfterFound, boolean continueOnInputError) {
        super(context, (Object)options, queue, operation);
        this.filter = filter;
        this.stopAfterFound = stopAfterFound;
        this.continueOnInputError = continueOnInputError;
    }

    public void run() {
        this.operation.start();
        File inputFile = ((BasicImportOptions)this.options).getInput();
        try {
            if (!inputFile.exists()) {
                this.context.getLog().error("Input file '{}' doesn't exist", new Object[]{inputFile.getPath()});
            } else if (inputFile.isDirectory()) {
                this.importDirectory(inputFile);
            } else {
                this.importFile(inputFile);
            }
        }
        finally {
            this.markDone();
            if (this.isWorkersDone() && !this.operation.isFinished()) {
                this.operation.producerFinish();
            }
        }
    }

    private void importFile(File inputFile) {
        Log log = this.context.getLog();
        try (InputStream input = this.openInputStream(inputFile);){
            if (!((BasicImportOptions)this.options).isZip()) {
                this.processStream(input);
            } else {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(input);
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    log.info("Processing file {}", new Object[]{entry.getName()});
                    this.processStream((InputStream)zis);
                }
            }
        }
        catch (Exception ex) {
            log.error("Unexpected error occurred", ex, new Object[0]);
        }
    }

    private void importDirectory(File inputFile) {
        Log log = this.context.getLog();
        Collection files = FileUtils.listFiles((File)inputFile, (String[])new String[]{"xml"}, (boolean)true);
        for (File file : files) {
            try (FileInputStream is = new FileInputStream(file);){
                log.info("Processing file {}", new Object[]{file.getName()});
                this.processStream((InputStream)is);
            }
            catch (Exception ex) {
                log.error("Unexpected error occurred", ex, new Object[0]);
            }
        }
    }

    private InputStream openInputStream(File input) throws IOException {
        InputStream is;
        if (input != null) {
            if (!input.exists()) {
                throw new NinjaException("Import file '" + input.getPath() + "' doesn't exist");
            }
            is = new FileInputStream(input);
        } else {
            is = System.in;
        }
        return is;
    }

    private void processStream(InputStream input) {
        ApplicationContext appContext = this.context.getApplicationContext();
        PrismContext prismContext = (PrismContext)appContext.getBean(PrismContext.class);
        MatchingRuleRegistry matchingRuleRegistry = (MatchingRuleRegistry)appContext.getBean(MatchingRuleRegistry.class);
        1 handler = new /* Unavailable Anonymous Inner Class!! */;
        LegacyValidator validator = new LegacyValidator(prismContext, (EventHandler)handler);
        validator.setValidateSchema(false);
        validator.setCompatMode(this.compatMode);
        validator.setConvertMissingType(this.isConvertMissingType());
        OperationResult result = this.operation.getResult();
        Charset charset = this.context.getCharset();
        InputStreamReader reader = new InputStreamReader(input, charset);
        validator.validate((InputStream)new ReaderInputStream((Reader)reader, charset), result, result.getOperation());
    }

    private boolean matchSelectedType(Class<?> clazz) {
        if (((BasicImportOptions)this.options).getType().isEmpty()) {
            return true;
        }
        for (ObjectTypes type : ((BasicImportOptions)this.options).getType()) {
            if (!type.getClassDefinition().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private String getErrorMessage() {
        if (this.currentOid != null && !this.currentOid.isBlank()) {
            return "Couldn't import object with oid '" + this.currentOid + "'";
        }
        return "Couldn't import object";
    }

    public boolean isConvertMissingType() {
        return this.convertMissingType;
    }

    public void setConvertMissingType(boolean convertMissingType) {
        this.convertMissingType = convertMissingType;
    }

    public void setCompatMode(boolean mode) {
        this.compatMode = mode;
    }
}

