/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.action.worker.ExportFocusStatisticsWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public class ExportFocusStatisticsWorker
extends AbstractWriterConsumerWorker<ExportOptions, ObjectType> {
    Map<Class<?>, StatisticsState> focusTypeStates = new HashMap();

    public ExportFocusStatisticsWorker(NinjaContext context, ExportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
    }

    protected String getProlog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<c:objects xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:org=\"http://midpoint.evolveum.com/xml/ns/public/common/org-3\">\n";
    }

    protected void write(Writer writer, ObjectType object) throws SchemaException, IOException {
        StatisticsState state = this.getState(object);
        state.process(object);
    }

    private StatisticsState getState(ObjectType object) {
        return this.focusTypeStates.computeIfAbsent(object.getClass(), k -> new StatisticsState(this, k));
    }

    protected String getEpilog() {
        StringWriter ret = new StringWriter();
        for (Map.Entry entry : this.focusTypeStates.entrySet()) {
            this.context.getLog().info("Focus Type {}. Processed {}", new Object[]{((Class)entry.getKey()).getSimpleName(), ((StatisticsState)entry.getValue()).totalCount});
        }
        ret.append("</c:objects>\n");
        return ret.toString();
    }
}

