/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.common.crypto.CryptoUtil;
import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.upgrade.action.InitialObjectsOptions;
import com.evolveum.midpoint.ninja.action.upgrade.action.InitialObjectsResult;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.util.BasicLightweightIdentifierGenerator;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.crypto.EncryptionException;
import com.evolveum.midpoint.prism.crypto.Protector;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.impl.binding.AbstractReferencable;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.repo.api.RepoAddOptions;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.GetOperationOptionsBuilder;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.merger.SimpleObjectMergeOperation;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ArchetypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.IterativeScriptingWorkDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ScheduleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.SystemObjectsType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskExecutionStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskRecurrenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.midpoint.xml.ns._public.model.scripting_3.ActionExpressionType;
import com.evolveum.midpoint.xml.ns._public.model.scripting_3.ObjectFactory;
import com.evolveum.prism.xml.ns._public.query_3.QueryType;
import com.evolveum.prism.xml.ns._public.query_3.SearchFilterType;
import com.evolveum.prism.xml.ns._public.types_3.ObjectDeltaType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class InitialObjectsAction
extends Action<InitialObjectsOptions, ActionResult<InitialObjectsResult>> {
    private static final String INITIAL_OBJECTS_RESOURCE_PATTERN = "classpath*:/initial-objects/**/*.xml";
    private static final String OPERATION_UPDATE_OBJECTS = "Initial objects update";
    private static final String OPERATION_PROCESS_FILE = "Process file";

    public String getOperationName() {
        return "initial objects";
    }

    public LogTarget getLogTarget() {
        if (!((InitialObjectsOptions)this.options).isReport()) {
            return LogTarget.SYSTEM_OUT;
        }
        return ((InitialObjectsOptions)this.options).getOutput() != null ? LogTarget.SYSTEM_OUT : LogTarget.SYSTEM_ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionResult<InitialObjectsResult> execute() throws Exception {
        InitialObjectsResult actionResult = new InitialObjectsResult();
        Writer writer = null;
        try {
            if (((InitialObjectsOptions)this.options).isReport()) {
                writer = NinjaUtils.createWriter((File)((InitialObjectsOptions)this.options).getOutput(), (Charset)this.context.getCharset(), (boolean)((InitialObjectsOptions)this.options).isZip(), (boolean)((InitialObjectsOptions)this.options).isOverwrite(), (PrintStream)this.context.out);
                if (((InitialObjectsOptions)this.options).getReportStyle() == InitialObjectsOptions.ReportStyle.DELTA) {
                    writer.write("<deltas xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/api-types-3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ObjectDeltaListType\">\n");
                } else {
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<c:objects xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:c=\"http://midpoint.evolveum.com/xml/ns/public/common/common-3\"\n\txmlns:org=\"http://midpoint.evolveum.com/xml/ns/public/common/org-3\">\n");
                }
            }
            OperationResult result = new OperationResult(OPERATION_UPDATE_OBJECTS);
            ArrayList<Object> resources = new ArrayList<Object>();
            List files = ((InitialObjectsOptions)this.options).getFiles();
            if (files != null && !files.isEmpty()) {
                for (Object file : ((InitialObjectsOptions)this.options).getFiles()) {
                    if (((File)file).isDirectory()) {
                        FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true).forEach(f -> resources.add(new FileSystemResource(f)));
                        continue;
                    }
                    resources.add(new FileSystemResource((File)file));
                }
            } else {
                Resource[] array = new PathMatchingResourcePatternResolver().getResources(INITIAL_OBJECTS_RESOURCE_PATTERN);
                resources.addAll(Arrays.asList(array));
            }
            resources.sort(Comparator.comparing(Resource::getFilename));
            ArrayList<ObjectReferenceType> refs = new ArrayList<ObjectReferenceType>();
            for (Resource resource : resources) {
                actionResult.incrementTotal();
                ObjectReferenceType ref = this.processFile(resource, result, actionResult, writer);
                if (ref == null) continue;
                refs.add(ref);
            }
            this.log.info("", new Object[0]);
            if (!refs.isEmpty()) {
                PrismObject task = this.createRecomputeTask(refs);
                this.context.getRepository().addObject(task, null, result);
                this.log.info("Recompute task {} created, it will be started after midpoint starts and will recompute {} objects.", new Object[]{task, refs.size()});
            } else {
                this.log.info("Recompute task not created, no objects were changed in repository.", new Object[0]);
            }
        }
        finally {
            if (writer != null) {
                if (((InitialObjectsOptions)this.options).getReportStyle() == InitialObjectsOptions.ReportStyle.DELTA) {
                    writer.write("</deltas>\n");
                } else {
                    writer.write("</c:objects>\n");
                }
                writer.flush();
                if (((InitialObjectsOptions)this.options).getOutput() != null) {
                    IOUtils.closeQuietly((Writer)writer);
                }
            }
        }
        int status = actionResult.getError() == 0 ? 0 : 1;
        this.log.info("", new Object[0]);
        this.log.info("Initial objects update finished. {}, {}, {} and {}, total: {} files processed.", new Object[]{ConsoleFormat.formatMessageWithSuccessParameters((String)"{} added", (Object[])new Object[]{actionResult.getAdded()}), ConsoleFormat.formatMessageWithInfoParameters((String)"{} merged", (Object[])new Object[]{actionResult.getMerged()}), ConsoleFormat.formatMessageWithParameters((String)"{} unchanged", (Object[])new Object[]{actionResult.getUnchanged()}, (ConsoleFormat.Color)ConsoleFormat.Color.DEFAULT), ConsoleFormat.formatMessageWithErrorParameters((String)"{} errors", (Object[])new Object[]{actionResult.getError()}), actionResult.getTotal()});
        return new ActionResult((Object)actionResult, status);
    }

    private <O extends ObjectType> boolean matchFilter(PrismObject<O> object) {
        boolean matches;
        Set types = ((InitialObjectsOptions)this.options).getType() != null ? ((InitialObjectsOptions)this.options).getType() : Collections.emptySet();
        boolean reverseTypeFilter = ((InitialObjectsOptions)this.options).isReverseTypeFilter();
        ObjectTypes type = ObjectTypes.getObjectType((Class)object.getCompileTimeClass());
        if (!types.isEmpty()) {
            matches = types.contains(type) != reverseTypeFilter;
        } else {
            boolean bl = matches = !reverseTypeFilter;
        }
        if (!matches) {
            return false;
        }
        Set oids = ((InitialObjectsOptions)this.options).getOid() != null ? ((InitialObjectsOptions)this.options).getOid() : Collections.emptySet();
        boolean reverseOidFilter = ((InitialObjectsOptions)this.options).isReverseOidFilter();
        String oid = object.getOid();
        if (!oids.isEmpty()) {
            return oids.contains(oid) != reverseOidFilter;
        }
        return !reverseOidFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <O extends ObjectType> ObjectReferenceType processFile(Resource resource, OperationResult parentResult, InitialObjectsResult actionResult, Writer writer) {
        OperationResult result = parentResult.createSubresult(OPERATION_PROCESS_FILE);
        PrismContext prismContext = this.context.getPrismContext();
        RepositoryService repository = this.context.getRepository();
        this.log.debug("File: {}", new Object[]{resource.getFilename()});
        try (InputStream is = resource.getInputStream();){
            String xml = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            PrismObject object = prismContext.parseObject(xml);
            if (!this.matchFilter(object)) {
                this.log.debug("Skipping object, object {} doesn't match defined filter.", new Object[]{NinjaUtils.printObjectNameOidAndType((PrismObject)object)});
                ObjectReferenceType objectReferenceType = null;
                return objectReferenceType;
            }
            PrismObject existing = null;
            try {
                Class type = object.getCompileTimeClass();
                GetOperationOptionsBuilder optionsBuilder = this.context.getSchemaService().getOperationOptionsBuilder();
                NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, (Class)type);
                existing = repository.getObject(type, object.getOid(), optionsBuilder.build(), result);
            }
            catch (ObjectNotFoundException type) {
                // empty catch block
            }
            boolean changed = false;
            if (existing == null) {
                changed = this.addObject(object, result, actionResult, writer, false);
            } else if (((InitialObjectsOptions)this.options).isNoMerge()) {
                if (!object.equivalent(existing)) {
                    changed = this.addObject(object, result, actionResult, writer, true);
                } else {
                    this.log.info("Object {} unchanged, skipping add.", new Object[]{NinjaUtils.printObjectNameOidAndType((PrismObject)existing)});
                    actionResult.incrementUnchanged();
                }
            } else {
                changed = this.mergeObject(object, existing, result, actionResult, writer);
            }
            if (!changed) return null;
            ObjectReferenceType objectReferenceType = new ObjectReferenceType().oid(object.getOid()).type(object.getComplexTypeDefinition().getTypeName());
            return objectReferenceType;
        }
        catch (Exception ex) {
            this.log.error("Unexpected exception occurred processing file {}", ex, new Object[]{resource.getFilename()});
            actionResult.incrementError();
        }
        return null;
    }

    private <O extends ObjectType> boolean mergeObject(PrismObject<O> initial, PrismObject<O> existing, OperationResult result, InitialObjectsResult actionResult, Writer writer) throws SchemaException, ConfigurationException, IOException {
        this.log.debug("Merging object {}", new Object[]{NinjaUtils.printObjectNameOidAndType(existing)});
        PrismObject merged = existing.clone();
        boolean mergeExecuted = this.mergeObject(merged, initial);
        if (!mergeExecuted) {
            this.log.error("Skipping object update, merge operation not supported for object {}.", new Object[]{NinjaUtils.printObjectNameOidAndType(existing)});
            actionResult.incrementError();
            return false;
        }
        ObjectDelta delta = existing.diff(merged);
        if (delta.isEmpty()) {
            this.log.info("Skipping object update, object {} merged, no differences found.", new Object[]{NinjaUtils.printObjectNameOidAndType(existing)});
            actionResult.incrementUnchanged();
            return false;
        }
        if (((InitialObjectsOptions)this.options).getReportStyle() == InitialObjectsOptions.ReportStyle.DELTA) {
            this.reportDelta(delta, writer);
        } else {
            this.reportObject(merged, writer);
        }
        boolean modified = false;
        try {
            this.log.info("Updating object {} in repository {}", new Object[]{NinjaUtils.printObjectNameOidAndType(existing), ((InitialObjectsOptions)this.options).isDryRun() ? "(dry run)" : ""});
            if (!((InitialObjectsOptions)this.options).isDryRun()) {
                this.context.getRepository().modifyObject(delta.getObjectTypeClass(), delta.getOid(), delta.getModifications(), result);
                modified = true;
            }
            actionResult.incrementMerged();
        }
        catch (ObjectAlreadyExistsException | ObjectNotFoundException | SchemaException ex) {
            this.log.error("Couldn't modify object {} ({}, {})", (Exception)ex, new Object[]{existing.getName(), existing.getOid(), existing.toDebugType()});
            actionResult.incrementError();
        }
        return modified;
    }

    private <O extends ObjectType> boolean mergeObject(PrismObject<O> target, PrismObject<O> source) throws SchemaException, ConfigurationException {
        if (target.equivalent(source)) {
            return true;
        }
        if (!SimpleObjectMergeOperation.isMergeSupported(target)) {
            return false;
        }
        SimpleObjectMergeOperation.merge(target, source);
        return true;
    }

    private <O extends ObjectType> void reportObject(PrismObject<O> object, Writer writer) throws SchemaException, IOException {
        String xml = (String)this.context.getPrismContext().xmlSerializer().serialize((PrismValue)object.getValue(), (QName)SchemaConstantsGenerated.C_OBJECT);
        writer.write(xml);
    }

    private <O extends ObjectType> void reportAddDelta(PrismObject<O> object, Writer writer) throws SchemaException, IOException {
        if (((InitialObjectsOptions)this.options).getReportStyle() == InitialObjectsOptions.ReportStyle.FULL_OBJECT) {
            this.reportObject(object, writer);
            return;
        }
        ObjectDelta delta = this.context.getPrismContext().deltaFactory().object().createEmptyAddDelta(object.getCompileTimeClass(), object.getOid());
        delta.setObjectToAdd(object);
        this.reportDelta(delta, writer);
    }

    private <O extends ObjectType> void reportDelta(ObjectDelta<O> delta, Writer writer) throws SchemaException, IOException {
        if (writer == null || !((InitialObjectsOptions)this.options).isReport()) {
            return;
        }
        ObjectDeltaType deltaType = DeltaConvertor.toObjectDeltaType(delta);
        String xml = (String)this.context.getPrismContext().xmlSerializer().serializeRealValue((Object)deltaType, NinjaUtils.DELTA_LIST_DELTA);
        writer.write(xml);
    }

    private <O extends ObjectType> boolean addObject(PrismObject<O> object, OperationResult result, InitialObjectsResult actionResult, Writer writer, boolean overwrite) throws SchemaException, IOException {
        if (!((InitialObjectsOptions)this.options).isForceAdd() && !overwrite) {
            this.log.info("Skipping object add (force-add options is not set), object {} will be correctly added during midpoint startup.", new Object[]{NinjaUtils.printObjectNameOidAndType(object)});
            return false;
        }
        this.reportAddDelta(object, writer);
        boolean added = false;
        try {
            this.log.info("Adding object {} {} to repository {}", new Object[]{overwrite ? "(overwrite)" : "", NinjaUtils.printObjectNameOidAndType(object), ((InitialObjectsOptions)this.options).isDryRun() ? "(dry run)" : ""});
            if (!((InitialObjectsOptions)this.options).isDryRun()) {
                Protector protector = (Protector)this.context.getApplicationContext().getBean(Protector.class);
                CryptoUtil.encryptValues((Protector)protector, object);
                RepoAddOptions opts = overwrite ? RepoAddOptions.createOverwrite() : null;
                this.context.getRepository().addObject(object, opts, result);
                added = true;
            }
            actionResult.incrementAdded();
        }
        catch (EncryptionException | ObjectAlreadyExistsException | SchemaException ex) {
            this.log.error("Couldn't add object {} to repository", (Exception)ex, new Object[]{NinjaUtils.printObjectNameOidAndType(object)});
            actionResult.incrementError();
        }
        return added;
    }

    private PrismObject<TaskType> createRecomputeTask(List<ObjectReferenceType> refs) throws SchemaException {
        TaskType task = new TaskType();
        task.setOid(UUID.randomUUID().toString());
        task.setName(new PolyStringType("Initial objects recompute after upgrade to 4.8"));
        task.setExecutionState(TaskExecutionStateType.RUNNABLE);
        task.setTaskIdentifier(new BasicLightweightIdentifierGenerator().generate().toString());
        task.setOwnerRef(new ObjectReferenceType().oid(SystemObjectsType.USER_ADMINISTRATOR.value()).type(UserType.COMPLEX_TYPE));
        ObjectReferenceType archetypeRef = new ObjectReferenceType().oid(SystemObjectsType.ARCHETYPE_ITERATIVE_BULK_ACTION_TASK.value()).type(ArchetypeType.COMPLEX_TYPE);
        AssignmentType assignment = new AssignmentType().targetRef(archetypeRef);
        task.getAssignment().add(assignment);
        task.getArchetypeRef().add(archetypeRef.clone());
        task.schedule(new ScheduleType().recurrence(TaskRecurrenceType.SINGLE));
        ObjectFilter filter = this.context.getPrismContext().queryFor(ObjectType.class).id((String[])refs.stream().map(AbstractReferencable::getOid).toArray(String[]::new)).buildFilter();
        SearchFilterType searchFilter = this.context.getPrismContext().getQueryConverter().createSearchFilterType(filter);
        IterativeScriptingWorkDefinitionType iterativeScripting = new IterativeScriptingWorkDefinitionType();
        ((IterativeScriptingWorkDefinitionType)iterativeScripting.beginObjects().type(ObjectType.COMPLEX_TYPE).query(new QueryType().filter(searchFilter)).end()).beginScriptExecutionRequest().scriptingExpression(new ObjectFactory().createAction(new ActionExpressionType().type("recompute")));
        task.beginActivity().beginWork().iterativeScripting(iterativeScripting).end();
        return task.asPrismObject();
    }
}

