/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade;

import com.evolveum.midpoint.ninja.action.upgrade.SkipUpgradeItem;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectResult;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectsItemsSummary;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeObjectsOptions;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.schema.validator.ObjectUpgradeValidator;
import com.evolveum.midpoint.schema.validator.UpgradeObjectProcessor;
import com.evolveum.midpoint.schema.validator.UpgradePriority;
import com.evolveum.midpoint.schema.validator.UpgradeProcessor;
import com.evolveum.midpoint.schema.validator.UpgradeValidationItem;
import com.evolveum.midpoint.schema.validator.UpgradeValidationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UpgradeObjectHandler {
    private final UpgradeObjectsOptions options;
    private final NinjaContext context;
    private final Map<UUID, Set<SkipUpgradeItem>> skipUpgradeItems;
    private final UpgradeObjectsItemsSummary itemsSummary;

    public UpgradeObjectHandler(UpgradeObjectsOptions options, NinjaContext context, Map<UUID, Set<SkipUpgradeItem>> skipUpgradeItems, UpgradeObjectsItemsSummary itemsSummary) {
        this.options = options;
        this.context = context;
        this.skipUpgradeItems = skipUpgradeItems;
        this.itemsSummary = itemsSummary;
    }

    @NotNull
    public <O extends ObjectType> UpgradeObjectResult execute(PrismObject<O> object) throws Exception {
        PrismContext prismContext = this.context.getPrismContext();
        ObjectUpgradeValidator validator = new ObjectUpgradeValidator(prismContext);
        validator.showAllWarnings();
        UpgradeValidationResult result = validator.validate(object);
        if (!result.hasChanges()) {
            return UpgradeObjectResult.NO_CHANGES;
        }
        List applicableItems = this.filterApplicableItems(object.getOid(), result.getItems());
        this.updateItemsSummary(result.getItems(), applicableItems);
        if (applicableItems.isEmpty()) {
            return UpgradeObjectResult.SKIPPED;
        }
        for (UpgradeValidationItem item : applicableItems) {
            String identifier = item.getIdentifier();
            if (identifier == null) continue;
            ItemPath path = item.getItem().getItemPath();
            UpgradeObjectProcessor processor = UpgradeProcessor.getProcessor((String)identifier);
            if (processor == null) continue;
            processor.process(object, path);
        }
        return UpgradeObjectResult.UPDATED;
    }

    private List<UpgradeValidationItem> filterApplicableItems(String oid, List<UpgradeValidationItem> items) {
        return items.stream().filter(item -> {
            if (!item.isChanged()) {
                return false;
            }
            if (!this.matchesOption(this.options.getIdentifiers(), (Object)item.getIdentifier())) {
                return false;
            }
            if (!this.matchesOption(this.options.getTypes(), (Object)item.getType())) {
                return false;
            }
            if (!this.matchesOption(this.options.getPhases(), (Object)item.getPhase())) {
                return false;
            }
            if (!this.matchesOption(this.options.getPriorities(), (Object)item.getPriority())) {
                return false;
            }
            ItemPath path = item.getItem().getItemPath();
            if (path == null) {
                return true;
            }
            Set skipItems = this.skipUpgradeItems.getOrDefault(UUID.fromString(oid), new HashSet());
            for (SkipUpgradeItem skipItem : skipItems) {
                if (!Objects.equals(skipItem.getPath(), path.toString()) || !Objects.equals(skipItem.getIdentifier(), item.getIdentifier())) continue;
                return false;
            }
            return true;
        }).sorted(Comparator.comparing(UpgradeValidationItem::getIdentifier)).collect(Collectors.toList());
    }

    private <T> boolean matchesOption(List<T> options, T option) {
        if (options == null || options.isEmpty()) {
            return true;
        }
        return options.stream().anyMatch(o -> o.equals(option));
    }

    private void updateItemsSummary(List<UpgradeValidationItem> allItems, List<UpgradeValidationItem> applicableItems) {
        for (UpgradeValidationItem item : allItems) {
            UpgradePriority priority = item.getPriority();
            UpgradeObjectsItemsSummary.ItemStatus status = applicableItems.contains(item) ? UpgradeObjectsItemsSummary.ItemStatus.PROCESSED : UpgradeObjectsItemsSummary.ItemStatus.SKIPPED;
            this.itemsSummary.increment(priority, status);
        }
    }
}

