/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.stats;

import com.evolveum.midpoint.ninja.action.stats.FocusStats;
import com.evolveum.midpoint.ninja.action.stats.FocusTypeCounter;
import com.evolveum.midpoint.ninja.action.stats.FocusTypeStats;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class StatsCounter {
    private final Map<Class<? extends ObjectType>, FocusTypeCounter> typesCounters;
    private final Predicate<Item<?, ?>> itemsToIncludePredicate;

    public StatsCounter(Predicate<Item<?, ?>> itemsToIncludePredicate) {
        this.itemsToIncludePredicate = itemsToIncludePredicate;
        this.typesCounters = new HashMap();
    }

    void count(ObjectType object) {
        PrismObject prismObject = object.asPrismObject();
        String objectName = prismObject.getElementName().getLocalPart();
        FocusTypeCounter counter = this.typesCounters.computeIfAbsent(object.getClass(), key -> new FocusTypeCounter(objectName, this.itemsToIncludePredicate));
        counter.count(prismObject);
    }

    FocusStats calculate() {
        List<FocusTypeStats> focusTypesStats = this.typesCounters.values().stream().map(FocusTypeCounter::calculate).toList();
        return new FocusStats(focusTypesStats);
    }
}

