/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.stats;

import com.evolveum.midpoint.ninja.action.stats.FocusTypeStats;
import com.evolveum.midpoint.ninja.action.stats.MagnitudeCounter;
import com.evolveum.midpoint.ninja.action.stats.PropertyStats;
import com.evolveum.midpoint.ninja.action.stats.PropertyStatsCounter;
import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.xml.namespace.QName;

class FocusTypeCounter {
    private final String focusType;
    private final Predicate<Item<?, ?>> itemsIncludePredicate;
    private final Map<String, PropertyStatsCounter> statsCounterMap;
    private final MagnitudeCounter totalCount;

    FocusTypeCounter(String focusType, Predicate<Item<?, ?>> itemsIncludePredicate) {
        this.focusType = focusType;
        this.itemsIncludePredicate = itemsIncludePredicate;
        this.totalCount = new MagnitudeCounter();
        this.statsCounterMap = new HashMap();
    }

    void count(PrismObject<? extends ObjectType> object) {
        this.totalCount.increment();
        List propertyDefinitions = object.getDefinition().getPropertyDefinitions();
        Collection properties = this.collectProperties((PrismContainerValue)object.getValue(), (Collection)propertyDefinitions);
        try {
            PrismContainer extension = object.getOrCreateExtension();
            properties.addAll(this.flatten(extension));
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        properties.forEach(property -> {
            String propertyPath = property.getPath().toString();
            PropertyStatsCounter counter = this.statsCounterMap.computeIfAbsent(propertyPath, key -> new PropertyStatsCounter(propertyPath));
            counter.count(property);
        });
    }

    FocusTypeStats calculate() {
        List<PropertyStats> propertiesStats = this.statsCounterMap.values().stream().map(PropertyStatsCounter::calculate).toList();
        return new FocusTypeStats(this.focusType, this.totalCount.toOrderOfMagnitude(), propertiesStats);
    }

    private Collection<PrismProperty<?>> flatten(PrismContainer<?> container) {
        if (this.isExcluded(container)) {
            return Collections.emptyList();
        }
        ComplexTypeDefinition complexTypeDefinition = container.getComplexTypeDefinition();
        PrismContainerValue containerValue = container.hasNoValues() ? container.createNewValue() : container.getValue();
        ArrayList propertyDefinitions = new ArrayList();
        complexTypeDefinition.getDefinitions().forEach(def -> {
            if (def instanceof PrismPropertyDefinition) {
                propertyDefinitions.add((PrismPropertyDefinition)def);
            }
        });
        Collection currentLevelProperties = this.collectProperties(containerValue, propertyDefinitions);
        ArrayList nestedProperties = new ArrayList();
        for (ItemDefinition definition : complexTypeDefinition.getDefinitions()) {
            if (!(definition instanceof PrismContainerDefinition)) continue;
            PrismContainerDefinition containerDefinition = (PrismContainerDefinition)definition;
            if (!definition.isSingleValue() || definition.isElaborate()) continue;
            try {
                PrismContainer innerContainer = containerValue.findOrCreateContainer((QName)containerDefinition.getItemName());
                nestedProperties.addAll(this.flatten(innerContainer));
            }
            catch (SchemaException e) {
                throw new RuntimeException(e);
            }
        }
        currentLevelProperties.addAll(nestedProperties);
        return currentLevelProperties;
    }

    private Collection<PrismProperty<?>> collectProperties(PrismContainerValue<?> containerValue, Collection<PrismPropertyDefinition<?>> propertyDefinitions) {
        ArrayList properties = new ArrayList();
        for (PrismPropertyDefinition<?> definition : propertyDefinitions) {
            PrismProperty property;
            try {
                property = containerValue.findOrCreateProperty(definition);
            }
            catch (SchemaException e) {
                throw new RuntimeException(e);
            }
            if (this.isExcluded((Item)property)) continue;
            properties.add(property);
        }
        return properties;
    }

    private boolean isExcluded(Item<?, ?> item) {
        return !this.itemsIncludePredicate.test(item);
    }
}

