/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.ninja.action.BasicImportOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.audit.ImportAuditConsumerWorker;
import com.evolveum.midpoint.ninja.action.audit.ImportAuditOptions;
import com.evolveum.midpoint.ninja.action.worker.ImportProducerWorker;
import com.evolveum.midpoint.ninja.action.worker.ProgressReporterWorker;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ImportAuditRepositoryAction
extends RepositoryAction<ImportAuditOptions, Void> {
    private static final int QUEUE_CAPACITY_PER_THREAD = 100;
    private static final long CONSUMERS_WAIT_FOR_START = 2000L;
    public static final String OPERATION_SHORT_NAME = "importAudit";
    public static final String OPERATION_NAME = ImportAuditRepositoryAction.class.getName() + ".importAudit";

    public String getOperationName() {
        return "import audit";
    }

    public Void execute() throws Exception {
        OperationResult result = new OperationResult(OPERATION_NAME);
        OperationStatus progress = new OperationStatus(this.context, result);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(100 * ((ImportAuditOptions)this.options).getMultiThread());
        ExecutorService executor = Executors.newFixedThreadPool(((ImportAuditOptions)this.options).getMultiThread() + 2);
        ObjectFilter filter = NinjaUtils.createObjectFilter((FileReference)((ImportAuditOptions)this.options).getFilter(), (NinjaContext)this.context, AuditEventRecordType.class);
        ImportProducerWorker producer = this.importByFilter(filter, false, queue, progress);
        executor.execute((Runnable)producer);
        Thread.sleep(2000L);
        executor.execute((Runnable)new ProgressReporterWorker(this.context, this.options, queue, progress));
        List consumers = this.createConsumers(queue, progress);
        consumers.forEach(c -> executor.execute((Runnable)c));
        executor.shutdown();
        boolean awaitResult = executor.awaitTermination(365L, TimeUnit.DAYS);
        if (!awaitResult) {
            this.log.error("Executor did not finish before timeout", new Object[0]);
        }
        this.handleResultOnFinish(null, progress, "Audit import finished");
        return null;
    }

    public LogTarget getLogTarget() {
        if (((ImportAuditOptions)this.options).getInput() != null) {
            return LogTarget.SYSTEM_OUT;
        }
        return LogTarget.SYSTEM_ERR;
    }

    private ImportProducerWorker<AuditEventRecordType> importByFilter(ObjectFilter filter, boolean stopAfterFound, BlockingQueue<AuditEventRecordType> queue, OperationStatus status) {
        ImportProducerWorker ret = new ImportProducerWorker(this.context, (BasicImportOptions)this.options, queue, status, filter, stopAfterFound, false);
        ret.setConvertMissingType(true);
        ret.setCompatMode(true);
        return ret;
    }

    private List<ImportAuditConsumerWorker> createConsumers(BlockingQueue<AuditEventRecordType> queue, OperationStatus operation) {
        ArrayList<ImportAuditConsumerWorker> consumers = new ArrayList<ImportAuditConsumerWorker>();
        for (int i = 0; i < ((ImportAuditOptions)this.options).getMultiThread(); ++i) {
            consumers.add(new ImportAuditConsumerWorker(this.context, (ImportAuditOptions)this.options, queue, operation, consumers));
        }
        return consumers;
    }
}

