/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.audit.api.AuditResultHandler;
import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.ninja.action.audit.BaseAuditImportExportOptions;
import com.evolveum.midpoint.ninja.action.worker.BaseWorker;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.schema.GetOperationOptionsBuilder;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class ExportAuditProducerWorker
extends BaseWorker<BaseAuditImportExportOptions, AuditEventRecordType> {
    private final ObjectQuery query;

    public ExportAuditProducerWorker(NinjaContext context, BaseAuditImportExportOptions options, BlockingQueue<AuditEventRecordType> queue, OperationStatus operation, List<ExportAuditProducerWorker> producers, ObjectQuery query) {
        super(context, (Object)options, queue, operation, producers);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log log = this.context.getLog();
        try {
            GetOperationOptionsBuilder optionsBuilder = this.context.getSchemaService().getOperationOptionsBuilder();
            optionsBuilder = NinjaUtils.addIncludeOptionsForExport((GetOperationOptionsBuilder)optionsBuilder, AuditEventRecordType.class);
            AuditResultHandler handler = (object, parentResult) -> {
                try {
                    this.queue.put(object);
                }
                catch (InterruptedException ex) {
                    log.error("Couldn't queue object {}, reason: {}", (Exception)ex, new Object[]{object, ex.getMessage()});
                }
                return true;
            };
            AuditService auditService = this.context.getAuditService();
            auditService.searchObjectsIterative(this.query, handler, optionsBuilder.build(), this.operation.getResult());
        }
        catch (SchemaException ex) {
            log.error("Unexpected exception, reason: {}", (Exception)((Object)ex), new Object[]{ex.getMessage()});
        }
        catch (NinjaException ex) {
            log.error(ex.getMessage(), (Exception)((Object)ex), new Object[0]);
        }
        finally {
            this.markDone();
            if (this.isWorkersDone() && !this.operation.isFinished()) {
                this.operation.producerFinish();
            }
        }
    }
}

