/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.BasicImportOptions;
import com.evolveum.midpoint.ninja.action.ImportOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.worker.ImportProducerWorker;
import com.evolveum.midpoint.ninja.action.worker.ImportRepositoryConsumerWorker;
import com.evolveum.midpoint.ninja.action.worker.ProgressReporterWorker;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ImportRepositoryAction
extends RepositoryAction<ImportOptions, Void> {
    private static final String DOT_CLASS = ImportProducerWorker.class.getName() + ".";
    private static final String OPERATION_IMPORT = DOT_CLASS + "import";
    private static final int QUEUE_CAPACITY_PER_THREAD = 100;
    private static final long CONSUMERS_WAIT_FOR_START = 2000L;

    public String getOperationName() {
        return "import objects";
    }

    public Void execute() throws Exception {
        ImportProducerWorker producer;
        OperationResult result = new OperationResult(OPERATION_IMPORT);
        OperationStatus progress = new OperationStatus(this.context, result);
        LinkedBlockingQueue queue = new LinkedBlockingQueue(100 * ((ImportOptions)this.options).getMultiThread());
        ExecutorService executor = Executors.newFixedThreadPool(((ImportOptions)this.options).getMultiThread() + 2);
        if (((ImportOptions)this.options).getOid() != null) {
            filter = this.context.getPrismContext().queryFactory().createInOid(new String[]{((ImportOptions)this.options).getOid()});
            producer = this.importByFilter(filter, true, queue, progress);
        } else {
            filter = NinjaUtils.createObjectFilter((FileReference)((ImportOptions)this.options).getFilter(), (NinjaContext)this.context, ObjectType.class);
            producer = this.importByFilter(filter, false, queue, progress);
        }
        executor.execute((Runnable)producer);
        Thread.sleep(2000L);
        executor.execute((Runnable)new ProgressReporterWorker(this.context, this.options, queue, progress));
        List consumers = this.createConsumers(queue, progress);
        consumers.forEach(c -> executor.execute((Runnable)c));
        executor.shutdown();
        boolean awaitResult = executor.awaitTermination(365L, TimeUnit.DAYS);
        if (!awaitResult) {
            this.log.error("Executor did not finish before timeout", new Object[0]);
        }
        this.handleResultOnFinish(null, progress, "Import finished");
        return null;
    }

    public LogTarget getLogTarget() {
        if (((ImportOptions)this.options).getInput() != null) {
            return LogTarget.SYSTEM_OUT;
        }
        return LogTarget.SYSTEM_ERR;
    }

    private ImportProducerWorker<ObjectType> importByFilter(ObjectFilter filter, boolean stopAfterFound, BlockingQueue<ObjectType> queue, OperationStatus status) {
        return new ImportProducerWorker(this.context, (BasicImportOptions)this.options, queue, status, filter, stopAfterFound, ((ImportOptions)this.options).isContinueOnInputError());
    }

    private List<ImportRepositoryConsumerWorker> createConsumers(BlockingQueue<ObjectType> queue, OperationStatus operation) {
        ArrayList<ImportRepositoryConsumerWorker> consumers = new ArrayList<ImportRepositoryConsumerWorker>();
        for (int i = 0; i < ((ImportOptions)this.options).getMultiThread(); ++i) {
            consumers.add(new ImportRepositoryConsumerWorker(this.context, (ImportOptions)this.options, queue, operation, consumers));
        }
        return consumers;
    }
}

