/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.ExportShadowStatisticsOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.stats.MagnitudeCounter;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemFactory;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.repo.api.AggregateQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.SearchResultList;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ShadowType;
import java.io.File;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import javax.xml.namespace.QName;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportShadowStatisticsAction
extends RepositoryAction<ExportShadowStatisticsOptions, Void> {
    private static final ItemName C_SHADOW_STATISTICS = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "shadowStatistics");
    private static final ItemName C_SHADOW = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "shadow");
    private static final ItemName F_COUNT = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "count");

    public String getOperationName() {
        return "export-statistics";
    }

    public Void execute() throws Exception {
        RepositoryService repository = this.context.getRepository();
        AggregateQuery query = ExportShadowStatisticsAction.createAggregationQuery();
        OperationResult result = new OperationResult("Shadow Statistics");
        SearchResultList aggregationResults = repository.searchAggregate(query, result);
        PrismContainer statisticsContainer = this.wrapAggregationResults(aggregationResults, ExportShadowStatisticsAction::changeCountsToMagnitude);
        PrismSerializer serializer = this.context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport());
        Writer writer = NinjaUtils.createWriter((File)((ExportShadowStatisticsOptions)this.options).getOutput(), (Charset)this.context.getCharset(), (boolean)((ExportShadowStatisticsOptions)this.options).isZip(), (boolean)((ExportShadowStatisticsOptions)this.options).isOverwrite(), (PrintStream)this.context.out);
        writer.write((String)serializer.serialize((Item)statisticsContainer));
        writer.flush();
        return null;
    }

    private PrismContainer<Containerable> wrapAggregationResults(SearchResultList<PrismContainerValue<?>> aggregationResults, Consumer<PrismContainerValue<?>> aggregationModifier) throws SchemaException {
        ItemFactory itemFactory = this.context.getPrismContext().itemFactory();
        PrismContainerValue statisticsValue = itemFactory.createContainerValue();
        PrismContainer shadowContainer = itemFactory.createContainer((QName)C_SHADOW);
        for (PrismContainerValue aggregation : aggregationResults) {
            try {
                aggregationModifier.accept(aggregation);
                PrismContainerValue castedAggregation = aggregation;
                shadowContainer.addIgnoringEquivalents((PrismValue)castedAggregation);
            }
            catch (SchemaException e) {
                this.log.error("Couldn't add shadow statistics", (Exception)((Object)e), new Object[0]);
            }
        }
        statisticsValue.add((Item)shadowContainer);
        PrismContainer statisticsContainer = itemFactory.createContainer((QName)C_SHADOW_STATISTICS);
        statisticsContainer.add((PrismValue)statisticsValue);
        return statisticsContainer;
    }

    private static AggregateQuery<ShadowType> createAggregationQuery() {
        return AggregateQuery.forType(ShadowType.class).retrieve(ShadowType.F_RESOURCE_REF).retrieve(ShadowType.F_OBJECT_CLASS).retrieve(ShadowType.F_KIND).retrieve(ShadowType.F_INTENT).retrieve(ShadowType.F_SYNCHRONIZATION_SITUATION).count(F_COUNT, (ItemPath)ShadowType.F_RESOURCE_REF);
    }

    private static void changeCountsToMagnitude(PrismContainerValue<?> aggregation) {
        PrismProperty count = aggregation.findProperty((ItemPath)F_COUNT);
        long orderOfMagnitude = new MagnitudeCounter(Math.toIntExact((Long)count.getRealValue(Long.class))).toOrderOfMagnitude();
        count.setRealValue((Object)orderOfMagnitude);
    }
}

