/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.util;

import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogLevel;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.schema.result.OperationResult;
import java.util.concurrent.atomic.AtomicInteger;

public class OperationStatus {
    private final NinjaContext context;
    private State state = State.NOT_STARTED;
    private final AtomicInteger totalCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private final AtomicInteger skippedCount = new AtomicInteger(0);
    private long startTime;
    private long finishTime;
    private int lastPrintoutCount;
    private final OperationResult result;

    public OperationStatus(NinjaContext context, OperationResult result) {
        this.context = context;
        this.result = result;
    }

    public OperationResult getResult() {
        return this.result;
    }

    public State getState() {
        return this.state;
    }

    public void start() {
        if (this.state != State.NOT_STARTED) {
            throw new NinjaException("Can't start operation, previous state is was not " + State.NOT_STARTED);
        }
        this.debug("Operation: started");
        this.startTime = System.currentTimeMillis();
        this.state = State.STARTED;
    }

    public void finish() {
        if (this.state == State.NOT_STARTED) {
            throw new NinjaException("Can't finish operation, previous state was " + State.NOT_STARTED);
        }
        this.debug("Operation: finished");
        this.finishTime = System.currentTimeMillis();
        this.state = State.FINISHED;
    }

    public void producerFinish() {
        if (this.state != State.STARTED) {
            throw new NinjaException("Can't set state " + State.PRODUCER_FINISHED + " for operation, previous state is was not " + State.STARTED);
        }
        this.debug("Operation: producer finished");
        this.state = State.PRODUCER_FINISHED;
    }

    public boolean isStarted() {
        return State.STARTED == this.state;
    }

    public boolean isFinished() {
        return State.FINISHED == this.state;
    }

    public boolean isProducerFinished() {
        return State.PRODUCER_FINISHED == this.state;
    }

    public int getTotalCount() {
        return this.totalCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getSkippedCount() {
        return this.skippedCount.get();
    }

    public void incrementTotal() {
        this.totalCount.incrementAndGet();
    }

    public void incrementError() {
        this.errorCount.incrementAndGet();
    }

    public void incrementSkipped() {
        this.skippedCount.incrementAndGet();
    }

    public double getTotalTime() {
        return (double)(this.finishTime - this.startTime) / 1000.0;
    }

    public double getAvgRequestPerSecond() {
        if (this.totalCount.get() == 0) {
            return 0.0;
        }
        double span = this.state == State.FINISHED ? (double)(this.finishTime - this.startTime) / 1000.0 : (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        return (double)this.totalCount.get() / span;
    }

    public String print() {
        return "Processed: " + this.totalCount.get() + ", error: " + this.errorCount.get() + ", skipped: " + this.skippedCount.get() + ", avg.: " + NinjaUtils.DECIMAL_FORMAT.format(this.getAvgRequestPerSecond()) + "obj/s";
    }

    public void print(Log log) {
        log.info(ConsoleFormat.rewriteConsoleLine((String)ConsoleFormat.formatLogMessage((LogLevel)LogLevel.INFO, (String)this.print())), new Object[0]);
        this.lastPrintoutNow();
    }

    public void lastPrintoutNow() {
        this.lastPrintoutCount = this.totalCount.get() - this.lastPrintoutCount;
    }

    private void debug(String message) {
        Log log = this.context.getLog();
        log.debug(message, new Object[0]);
    }
}

