/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.util;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ObjectTypesConverter
implements IStringConverter<Set<ObjectTypes>>,
IParameterValidator {
    public void validate(String name, String value) throws ParameterException {
        if (value == null) {
            return;
        }
        Set types = this.getType(value);
        if (types.isEmpty()) {
            throw new ParameterException("Unknown value " + value + " for option " + name);
        }
    }

    public Set<ObjectTypes> convert(String value) {
        if (value == null) {
            return new HashSet<ObjectTypes>();
        }
        Set types = this.getType(value);
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Unknown object type " + value);
        }
        return types;
    }

    private Set<ObjectTypes> getType(String value) {
        String[] items;
        HashSet<ObjectTypes> set = new HashSet<ObjectTypes>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return set;
        }
        for (String item : items = value.split(",")) {
            if (StringUtils.isEmpty((CharSequence)(item = item.trim()))) continue;
            boolean found = false;
            for (ObjectTypes o : ObjectTypes.values()) {
                if (!o.name().equalsIgnoreCase(item) && !o.getRestType().equalsIgnoreCase(item) && !o.getTypeQName().getLocalPart().equalsIgnoreCase(item) && !o.getElementName().getLocalPart().equalsIgnoreCase(item)) continue;
                set.add(o);
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Unknown object type '" + item + "'");
        }
        return set;
    }
}

